package com.bxm.datapark.facade.ocpc;

import com.bxm.datapark.facade.Page;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * OCPC 统计服务
 * @author allen
 * @since 1.0.0
 */
@FeignClient(name="datapark")
public interface OcpcStatisticsService {

    /**
     * ocpc统计查询服务
     * @param condition
     * @return
     */
    @RequestMapping(value = "/ocpcstatistics/find", method = RequestMethod.POST, consumes="application/json")
    Page<OcpcStatistics> find(@RequestBody OcpcStatisticsCondition condition);
}
