package com.bxm.datapark.facade.position.model.vo;

import java.io.Serializable;

import org.springframework.data.mongodb.core.mapping.Field;

/**
* @Title:PositionSpareTicket.java
* @Package:com.bxm.datapark.model.mongo.vo.position
* @Description: 广告位备用券实体类
* @date:2018年8月8日 下午6:08:29
 */
public class PositionSpareTicketVo implements Serializable{
    
    private static final long serialVersionUID = -695631274165783460L;

    /**
     * 广告位ID
     */
    @Field("positionid")
    private String positionId;
    
    /**
     * 媒体名称
     */
    @Field("app_name")
    private String appName;
    
    /**
     * 广告位名称
     */
    @Field("app_entrance_name")
    private String appEntranceName;
    
    /**
     * 媒介
     */
    @Field("medium")
    private String medium;
    
    /**
     * 发券量
     */
    @Field("open_pv")
    private Double openPv;
    
    /**
     * 备用券发券占比
     */
    @Field("spare_open_proportion")
    private Double spareOpenProportion;
    private String spareOpenProportionStr;

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppEntranceName() {
        return appEntranceName;
    }

    public void setAppEntranceName(String appEntranceName) {
        this.appEntranceName = appEntranceName;
    }

    public String getMedium() {
        return medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public Double getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Double openPv) {
        this.openPv = openPv;
    }

    public Double getSpareOpenProportion() {
        return spareOpenProportion;
    }

    public void setSpareOpenProportion(Double spareOpenProportion) {
        this.spareOpenProportion = spareOpenProportion;
    }

    public String getSpareOpenProportionStr() {
        return spareOpenProportionStr = spareOpenProportion !=null?(spareOpenProportion +"%"):"0.0%";
    }

    public void setSpareOpenProportionStr(String spareOpenProportionStr) {
        this.spareOpenProportionStr = spareOpenProportionStr;
    }
}
