/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with http://www.bianxianmao.com.
 */

package com.bxm.datapark.facade.activity;

import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;

/**
 * @author 拉拉
 * @description 挽留页数据
 * @time 2019/3/22
 * @CopyRight 杭州微财科技有限公司
 * @return
 */

public class RetentionCountVo implements Serializable {

    private static final long serialVersionUID = 1775836443028039200L;
    /**
     * 编号
     */
    private String number;
    /**
     * 日期
     */
    @Field("thedate")
    private String thedate;
    /**
     * 活动id
     */
    @Field("activity_id")
    private String activity_id;
    private String activityName;
    /**
     * app_key
     */
    @Field("app_key")
    private String app_key;

    /**
     * position_id
     */
    @Field("position_id")
    private String position_id;


    /**
     * 挽留页id
     * 名称
     * 类型
     * 环节
     * 策划
     * 设计
     * 广告位名称代号
     */
    @Field("retention_id")
    private String retention_id;
    private String retentionName;
    private String retentionType;
    private String retentionLink;
    private String planner;
    private String designer;
    private String positionName;
    /**
     * 挽留请求pv
     */
    @Field("request_pv")
    private Integer request_pv;

    /**
     * 曝光pv
     */
    @Field("exposure_pv")
    private Integer exposure_pv;
    /**
     * 到达率，2位小数，已乘100
     */
    @Field("arrival_rate")
    private Double arrival_rate;

    /**
     * 曝光uv
     */
    @Field("exposure_uv")
    private Integer exposure_uv;

    /**
     * 参与人数
     */
    @Field("join_uv")
    private Integer join_uv;
    /**
     * 参与次数
     */
    @Field("join_pv")
    private Integer join_pv;
    /**
     * 参与率，2位小数，已乘100
     */
    @Field("join_rate")
    private Double join_rate;
    /**
     * 发券量
     */
    @Field("open_pv")
    private Integer open_pv;
    /**
     * 重复发券，4位小数
     */
    @Field("rpt_open_pv")
    private Double rpt_open_pv;
    /**
     * 点击量
     */
    @Field("click_pv")
    private Integer click_pv;
    /**
     * 券点击率，2位小数，已乘100
     */
    @Field("click_rate")
    private Double click_rate;
    /**
     * 人均点击，4位小数
     */
    @Field("per_click_pv")
    private Double per_click_pv;
    /**
     * 人均发券，4位小数
     */
    @Field("per_open_pv")
    private Double per_open_pv;

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getThedate() {
        return thedate;
    }

    public void setThedate(String thedate) {
        this.thedate = thedate;
    }

    public String getRetention_id() {
        return retention_id;
    }

    public void setRetention_id(String retention_id) {
        this.retention_id = retention_id;
    }

    public Integer getRequest_pv() {
        return request_pv;
    }

    public void setRequest_pv(Integer request_pv) {
        this.request_pv = request_pv;
    }

    public Integer getExposure_pv() {
        return exposure_pv;
    }

    public void setExposure_pv(Integer exposure_pv) {
        this.exposure_pv = exposure_pv;
    }

    public Double getArrival_rate() {
        return arrival_rate;
    }

    public void setArrival_rate(Double arrival_rate) {
        this.arrival_rate = arrival_rate;
    }

    public Integer getExposure_uv() {
        return exposure_uv;
    }

    public void setExposure_uv(Integer exposure_uv) {
        this.exposure_uv = exposure_uv;
    }

    public Integer getJoin_uv() {
        return join_uv;
    }

    public void setJoin_uv(Integer join_uv) {
        this.join_uv = join_uv;
    }

    public Integer getJoin_pv() {
        return join_pv;
    }

    public void setJoin_pv(Integer join_pv) {
        this.join_pv = join_pv;
    }

    public Double getJoin_rate() {
        return join_rate;
    }

    public void setJoin_rate(Double join_rate) {
        this.join_rate = join_rate;
    }

    public Integer getOpen_pv() {
        return open_pv;
    }

    public void setOpen_pv(Integer open_pv) {
        this.open_pv = open_pv;
    }

    public Double getRpt_open_pv() {
        return rpt_open_pv;
    }

    public void setRpt_open_pv(Double rpt_open_pv) {
        this.rpt_open_pv = rpt_open_pv;
    }

    public Integer getClick_pv() {
        return click_pv;
    }

    public void setClick_pv(Integer click_pv) {
        this.click_pv = click_pv;
    }

    public Double getClick_rate() {
        return click_rate;
    }

    public void setClick_rate(Double click_rate) {
        this.click_rate = click_rate;
    }

    public Double getPer_click_pv() {
        return per_click_pv;
    }

    public void setPer_click_pv(Double per_click_pv) {
        this.per_click_pv = per_click_pv;
    }

    public Double getPer_open_pv() {
        return per_open_pv;
    }

    public void setPer_open_pv(Double per_open_pv) {
        this.per_open_pv = per_open_pv;
    }

    public String getRetentionName() {
        return retentionName;
    }

    public void setRetentionName(String retentionName) {
        this.retentionName = retentionName;
    }

    public String getRetentionType() {
        return retentionType;
    }

    public void setRetentionType(String retentionType) {
        this.retentionType = retentionType;
    }

    public String getRetentionLink() {
        return retentionLink;
    }

    public void setRetentionLink(String retentionLink) {
        this.retentionLink = retentionLink;
    }

    public String getPlanner() {
        return planner;
    }

    public void setPlanner(String planner) {
        this.planner = planner;
    }

    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    public String getApp_key() {
        return app_key;
    }

    public void setApp_key(String app_key) {
        this.app_key = app_key;
    }

    public String getPosition_id() {
        return position_id;
    }

    public void setPosition_id(String position_id) {
        this.position_id = position_id;
    }

    public String getActivity_id() {
        return activity_id;
    }

    public void setActivity_id(String activity_id) {
        this.activity_id = activity_id;
    }

    public RetentionCountVo() {
        this.request_pv = 0;
        this.exposure_pv = 0;
        this.arrival_rate = 0.0;
        this.exposure_uv = 0;
        this.join_uv = 0;
        this.join_pv = 0;
        this.join_rate = 0.0;
        this.open_pv = 0;
        this.rpt_open_pv = 0.0;
        this.click_pv = 0;
        this.click_rate = 0.0;
        this.per_click_pv = 0.;
        this.per_open_pv = 0.0;
    }

    public String getPositionName() {
        return positionName;
    }

    public void setPositionName(String positionName) {
        this.positionName = positionName;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }
}
