package com.bxm.datapark.facade.ticket.model.vo;

import org.springframework.data.mongodb.core.mapping.Field;

import java.math.BigDecimal;

/**
 * Created by wuwenquan on 2018/8/24.
 */
public class SendTicketVo {
    @Field("positionid")
    private String positionId;

    private  Double openPvArpu;
    @Field("open_pv_arpu_change")
    private  Double openPvArpuChange;
    @Field("income")
    private Double income;
    @Field("index_uv")
    private  Double indexUv;

    @Field("index_uv_change")
    private  Double  indexUvChange;

    @Field("open_pv")
    private Double openPv;

    @Field("open_pv_change")
    private Double openPvChange;

    @Field("per_open_pv")
    private Double perOpenPv;

    @Field("per_open_pv_change")
    private Double perOpenPvChange;

    @Field("per_click_pv")
    private Double perClickPv;

    @Field("per_click_pv_change")
    private Double perClickPvChange;
   //arpu差值绝对值
    private Double absArpu;
    /**
     * 开发者名称
     */
    private String     appName;

    /**
     * 广告位名称
     */
    private String      positionName;
    /**
     * 媒介
     * */
    private  String  mjcode;

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPositionName() {
        return positionName;
    }

    public void setPositionName(String positionName) {
        this.positionName = positionName;
    }

    public String getMjcode() {
        return mjcode;
    }

    public void setMjcode(String mjcode) {
        this.mjcode = mjcode;
    }

    public Double getOpenPvArpu() {
        return  div(this.income,this.openPv,2);
    }

    public void setOpenPvArpu(Double openPvArpu) {
        this.openPvArpu = openPvArpu;
    }


    public Double getOpenPvArpuChange() {
        return null==openPvArpuChange?0:openPvArpuChange;
    }

    public void setOpenPvArpuChange(Double openPvArpuChange) {
        this.openPvArpuChange = openPvArpuChange;
    }

    public Double getIndexUv() {
        return null==indexUv?0:indexUv;
    }

    public void setIndexUv(Double indexUv) {
        this.indexUv = indexUv;
    }

    public Double getIndexUvChange() {
        return null==indexUvChange?0:indexUvChange;
    }

    public void setIndexUvChange(Double indexUvChange) {
        this.indexUvChange = indexUvChange;
    }

    public Double getOpenPv() {
        return null==openPv?0:openPv;
    }

    public void setOpenPv(Double openPv) {
        this.openPv = openPv;
    }

    public Double getOpenPvChange() {
        return null==openPvChange?0:openPvChange;
    }

    public void setOpenPvChange(Double openPvChange) {
        this.openPvChange = openPvChange;
    }

    public Double getPerOpenPv() {
        return null==perOpenPv?0:perOpenPv;
    }

    public void setPerOpenPv(Double perOpenPv) {
        this.perOpenPv = perOpenPv;
    }

    public Double getPerOpenPvChange() {
        return null==perOpenPvChange?0:perOpenPvChange;
    }

    public void setPerOpenPvChange(Double perOpenPvChange) {
        this.perOpenPvChange = perOpenPvChange;
    }

    public Double getPerClickPv() {
        return null==perClickPv?0:perClickPv;
    }

    public void setPerClickPv(Double perClickPv) {
        this.perClickPv = perClickPv;
    }

    public Double getPerClickPvChange() {
        return null==perClickPvChange?0:perClickPvChange;
    }

    public void setPerClickPvChange(Double perClickPvChange) {
        this.perClickPvChange = perClickPvChange;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public Double getIncome() {
        return income==null?0D:income;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public Double getAbsArpu() {
     return  absArpu;
    }

    public void setAbsArpu(Double absArpu) {
        this.absArpu = absArpu;
    }

    /**
     * 两个Double数相除，并保留scale位小数
     * @param v1
     * @param v2
     * @param scale
     * @return Double
     */
    public static Double div(Double v1,Double v2,int scale){
        if (null==v1||null==v2||v2.doubleValue()==0||v1.doubleValue()==0){
            return 0D;
        }
        if(scale<0){
            throw new IllegalArgumentException(
                    "The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(v1.toString());
        BigDecimal b2 = new BigDecimal(v2.toString());
        return b1.divide(b2,scale,BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    @Override
    public String toString() {
        return "SendTicketVo{" +
                "openPvArpu=" + openPvArpu +
                ", openPvArpuChange=" + openPvArpuChange +
                '}';
    }
}
