package com.bxm.datapark.facade.ticket.model.vo;

import java.io.Serializable;

import org.springframework.data.mongodb.core.mapping.Field;

/**
* @Title:TicketExposureCount.java
* @Package:com.bxm.datapark.model.mongo.vo.newad
* @Description: 广告券落地页实体类
* @date:2018年8月8日 下午6:24:53
 */
public class TicketUrlVo implements Serializable{

    private static final long serialVersionUID = -7094702839663820368L;
    
    /**
     * 广告ID
     */
    @Field("certificate_id")
    private Long certificateId;
     
    /**
     * 广告名称
     */
    @Field("shopsname")
    private String shopsname;
    
    /**
     * 所属广告主
     */
    @Field("company")
    private String company;
    
    /**
     * AE
     */
    @Field("ae")
    private String ae;
    
    /**
     * 点击量
     */
    @Field("click_pv")
    private Double clickPv;
    
    /**
     * 落地页到答率
     */
    @Field("exposure_rate")
    private Double exposureRate;
    private String exposureRateStr;

    public Long getCertificateId() {
        return certificateId;
    }

    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    public String getShopsname() {
        return shopsname;
    }

    public void setShopsname(String shopsname) {
        this.shopsname = shopsname;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getAe() {
        return ae;
    }

    public void setAe(String ae) {
        this.ae = ae;
    }

    public Double getClickPv() {
        return clickPv;
    }

    public void setClickPv(Double clickPv) {
        this.clickPv = clickPv;
    }

    public Double getExposureRate() {
        return exposureRate;
    }

    public void setExposureRate(Double exposureRate) {
        this.exposureRate = exposureRate;
    }

    public String getExposureRateStr() {
        return exposureRateStr = exposureRate !=null?(exposureRate +"%"):"0.0%";
    }

    public void setExposureRateStr(String exposureRateStr) {
        this.exposureRateStr = exposureRateStr;
    }

}
