package com.bxm.datapark.web;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.web.model.SearchDataCommon;
import com.bxm.datapark.web.model.TicketData;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;
import java.util.Map;

/**
 * <h3>广告券相关的数据</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/11/11 14:00
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadeAdTicketDataService {

    @RequestMapping("/data/ticket/position")
    public ResultModel<List<TicketData>> getTicketPositionData(@RequestBody SearchDataCommon search);

    @RequestMapping("/data/ticket")
    public ResultModel<List<TicketData>> getAdTicketData(@RequestBody SearchDataCommon search);


}