package com.bxm.datapark.web;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.web.model.PositionData;
import com.bxm.datapark.web.model.SearchDataCommon;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;
import java.util.Map;

/**
 * <h3>OCPC</h3>
 *
 * @author tangxiao
 * @since V1.0.0, 2019/12/12 14:01
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadePositionDataService {

    @RequestMapping("/data/position")
    public ResultModel<List<PositionData>>  getPositionData(@RequestBody SearchDataCommon search);

    @RequestMapping("/data/media")
    public ResultModel<List<PositionData>>  getMediaData(@RequestBody SearchDataCommon search);


}
