package com.bxm.datapark.web.model.old.vo;

import com.bxm.warcar.utils.Constants;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * @author allen
 * @date 2017-12-05
 */
public class TicketAssets implements Serializable {
    private static final long serialVersionUID = 4368329874159718574L;

    public static final int VARS_NONE = 0;
    public static final int VARS_PROVINCE = 1;
    public static final int VARS_CITY = 2;

    private BigInteger id;
    private String name;
    private Byte vars;
    private String content;
    private String image;
    private String intro;
    private String buttonTxt;
    private Integer   clickThreshold;
    /**
     * 状态
     * @see Constants#YES
     * @see Constants#NO
     */
    private Byte status;

    public boolean isAvailable() {
        return null != status && status.byteValue() == Constants.YES;
    }

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getIntro() {
        return intro;
    }

    public void setIntro(String intro) {
        this.intro = intro;
    }

    public String getButtonTxt() {
        return buttonTxt;
    }

    public void setButtonTxt(String buttonTxt) {
        this.buttonTxt = buttonTxt;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Byte getVars() {
        return vars;
    }

    public void setVars(Byte vars) {
        this.vars = vars;
    }

    public Integer getClickThreshold() {
        return clickThreshold;
    }

    public void setClickThreshold(Integer clickThreshold) {
        this.clickThreshold = clickThreshold;
    }
}
