/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with http://www.bianxianmao.com.
 */

package com.bxm.datapark.web.model.old.vo.newad;

import com.bxm.util.dto.VoUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;

/**
 * @FileName com.bxm.datapark.model.mongo.vo.newad.AppCount.java
 * @CopyRright (c) 2017-bxm：weicai
 * @Creator qinganquan
 * @Created 2018-02-23 11:07:00
 * @Modifier qinganquan
 * @Updated 2018-02-23 11:07:00
 * @Description
 * @Version BUILD1001
 */
public class AppCount implements Serializable {


    private static final long serialVersionUID = 1775836443028039200L;
    /**
     * 编号
     */
    private String number;
    /**
     * 日期
     */

    private String datetime;

    /**
     * 开发者唯一标识
     */
    @Field("app_key")
    private String appKey;

    /**
     * 开发者唯一标识
     */
    @Field("business")
    private String business;

    /**
     * 广告位ID
     */
    private String positionId;
    /**
     * 广告位点击量
     */

    @Field("icon_click_pv")
    private Integer iconClickPv;

    /**
     * 广告位点击率
     */
    private Double iconClickPvRate;

    /**
     * 广告位点击率涨幅,已乘100
     */
    private String iconClickPvRateChange;

    /**
     * 入口点击pv环比昨日，已乘100
     */

    @Field("icon_click_change")
    private String iconClickChange;

    /**
     * 中间页uv
     */

    @Field("mid_page_uv")
    private Integer midPageUv;
    /**
     * 子链接发券数量
     */
    @Field("ticket_num")
    private Integer ticket_num;

    /**
     * 中间页uv环比昨日，已乘100
     */

    @Field("mid_uv_change")
    private String midUvChange;

    /**
     * 中间页pv(中间页曝光数)  原入口点击数
     */

    @Field("mid_page_pv")
    private Integer midPagePv;

    /**
     * 中间页pv环比昨日，已乘100
     */

    @Field("mid_pv_change")
    private String midPvChange;

    /**
     * 活动首页pv
     */

    @Field("index_pv")
    private Integer indexPv;

    /**
     * 活动首页pv环比昨日，已乘100
     */

    @Field("index_pv_change")
    private String indexPvChange;

    /**
     * 活动首页uv
     */

    @Field("index_uv")
    private Integer indexUv;

    /**
     * 活动首页uv环比昨日，已乘100
     */

    @Field("index_uv_change")
    private String indexUvChange;

    @Field("join_uv")
    private Integer joinUv;

    @Field("click_pv")
    private Integer clickPv;

    /**
     * 活动参与率
     */

    @Field("join_rate")
    private Double joinRate;

    /**
     * 活动参与率环比昨日，已乘100
     */

    @Field("join_rate_change")
    private String joinRateChange;

    /**
     * 发券请求量
     */

    @Field("send_pv")
    private Integer sendPv;

    /**
     * 发券请求环比昨日，已乘100
     */

    @Field("send_pv_change")
    private String sendPvChange;

    /**
     * 发券量
     */

    @Field("open_pv")
    private Integer openPv;

    /**
     * 发券量环比昨日，已乘100
     */

    @Field("open_pv_change")
    private String openPvChange;

    /**
     * 发券成功率
     */

    @Field("success_rate")
    private Double successRate;

    /**
     * 发券成功率环比昨日，已乘100
     */
    @Field("success_rate_change")
    private String successRateChange;

    /**
     * 安卓发券占比
     */

    @Field("android_open_rate")
    private Double androidOpenRate;

    /**
     * 安卓发券占比环比昨日，已乘100
     */

    @Field("android_rate_change")
    private String androidRateChange;

    /**
     * ios发券占比
     */

    @Field("ios_open_rate")
    private Double iosOpenRate;

    /**
     * ios发券占比环比昨日，已乘100
     */

    @Field("ios_rate_change")
    private String iosRateChange;

    /**
     * web发券占比
     */

    @Field("web_open_rate")
    private Double webOpenRate;

    /**
     * web发券占比环比昨日，已乘100
     */

    @Field("web_rate_change")
    private String webRateChange;

    /**
     * 微信发券占比
     */

    @Field("wechat_open_rate")
    private Double wechatOpenRate;

    /**
     * 微信发券占比环比昨日，已乘100
     */

    @Field("wechat_rate_change")
    private String wechatRateChange;

    /**
     * IMEI发券占比
     */
    @Field("imei_open_rate")
    private Double imeiOpenRate;

    /**
     * IMEI发券占比环比昨日，已乘100
     */
    @Field("imei_rate_change")
    private String imeiRateChange;

    /**
     * 老用户占比（当日uv中在前三天有访问记录的uv记为老用户）
     */
    @Field("old_rate")
    private Double oldRate;

    /**
     * 老用户占比环比昨日，已乘100
     */
    @Field("old_rate_change")
    private String oldRateChange;

    /**
     * 广告券点击率
     */
    @Field("click_rate")
    private Double clickRate;

    /**
     * 广告券点击率环比昨日，已乘100
     */
    @Field("click_rate_change")
    private String clickRateChange;

    /**
     * 人均发券量
     */
    @Field("per_open_pv")
    private Double perOpenPv;

    /**
     * 人均发券环比昨日，已乘100
     */
    @Field("per_open_pv_change")
    private String perOpenPvChange;

    /**
     * 人均重复发券
     */
    @Field("rpt_open_pv")
    private Double rptOpenPv;

    /**
     * 人均重复发券环比昨日，已乘100
     */
    @Field("rpt_open_pv_change")
    private String rptOpenPvChange;

    /**
     * 券收入
     */
    @Field("income")
    private Double income;

    /**
     * 券收入涨幅
     */
    @Field("income_change")
    private String incomeChange;
    /**
     * 开发者收益
     */
    @Field("developer_income")
    private Double developerIncome;
    /**
     * 开发者收益涨幅
     */
    @Field("developer_income_change")
    private String developerIncomeChange;
    /**
     * 变现猫收益
     */
    @Field("bxm_income")
    private Double bxmIncome;
    /**
     * 变现猫收益涨幅
     */
    @Field("bxm_income_change")
    private String bxmIncomeChange;
    /**
     * 发券ARUP(券收入除以发券量)
     */
    @Field("open_pv_arpu")
    private Double openPvAurp;
    /**
     * 发券ARUP涨幅
     */
    @Field("open_pv_arpu_change")
    private String openPvAurpChange;
    /**
     * UVARUP
     */
    @Field("uv_arpu")
    private Double uvAurp;
    /**
     * UVARUP涨幅
     */
    @Field("uv_arpu_change")
    private String uvAurpChange;
    /**
     * 开发者UVARUP
     */
    @Field("developer_arpu")
    private Double developerAurp;
    /**
     * 开发者UVARUP涨幅
     */
    @Field("developer_arpu_change")
    private String developerAurpChange;
    /**
     * 变现猫UVARUP
     */
    @Field("bxm_arpu")
    private Double bxmAurp;
    /**
     * 变现猫UVARUP涨幅
     */
    @Field("bxm_arpu_change")
    private String bxmAurpChange;
    /**
     * 子链接收益（排序）
     */
    @Field("business_income")
    private Double businessIncome;
    /**
     * 子链接收益涨幅
     */
    @Field("business_income_change")
    private String businessIncomeChange;
    /**
     * 子链接 UVAURP
     */
    @Field("business_arpu")
    private Double businessAurp;
    /**
     * 子链接 UVAURP 涨幅
     */
    @Field("business_arpu_change")
    private String businessAurpChange;

    /**
     * 券收入 UVAURP
     */
    @Field("income_aurp")
    private Double incomeAurp;
    /**
     * 券收入 UVAURP 涨幅
     */
    @Field("income_aurp_change")
    private String incomeAurpChange;

    /**
     * 广告位曝光数
     */
    @Field("icon_pv")
    private Integer iconPv;

    /**
     * 广告位曝光数涨幅
     */
    @Field("icon_change")
    private String iconChange;

    /**
     * 点击到达率
     */
    @Field("mid_page_rate")
    private Double midPageRate;

    /**
     * 点击到达率涨幅
     */
    @Field("mid_page_rate_change")
    private String midPageRateChange;

    /**
     * 首页曝光数
     */
    @Field("landing_page_pv")
    private Integer landingPagePv;

    /**
     * 首页曝光数涨幅
     */
    @Field("landing_page_change")
    private String landingPageChange;

    /**
     * 页面展现率
     */
    @Field("landing_page_rate")
    private Double landingPageRate;

    /**
     * 页面展现率涨幅
     */
    @Field("landing_rate_change")
    private String landingRateChange;


    /**
     * ecpm（券收入除以广告位曝光数）
     */
    @Field("ecpm")
    private Double ecpm;

    /**
     * ecpm涨幅
     */
    private String ecpmChange;

    /**
     * mEcpm 媒体ecpm（子链接收益除以广告位曝光数）
     */
    @Field("m_ecpm")
    private Double mEcpm;

    /**
     * mEcpm涨幅
     */
    private String mEcpmChange;
    /**
     * 人均点击量=人均券点击
     */
    @Field("per_click_pv")
    private Double perClickPv;

    /**
     * 人均点击量环比昨日
     */
    @Field("per_click_pv_change")
    private Double perClickPvChange;


    /**
     * 子链接UVarpu
     */
    private Double bussinessUvArpu;

    /**
     * 券收入UVArpu
     */
    private Double incomeUvArpu;

    /**
     * 分成比例
     */
    private String dividePercent;

    /**
     * 分成比例涨幅
     */
    private String dividePercentChange;

    public String getDatetime() {
        return datetime;
    }

    public String getAppKey() {
        return appKey;
    }

    public String getBusiness() {
        return business;
    }

    public Integer getIconClickPv() {
        return iconClickPv;
    }

    public String getIconClickChange() {
        return VoUtil.percentage(iconClickChange);
    }


    public String getMidUvChange() {
        return VoUtil.percentage(midUvChange);
    }

    public String getMidPvChange() {
        return VoUtil.percentage(midPvChange);
    }

    public Integer getIndexPv() {
        return indexPv;
    }

    public String getIndexPvChange() {
        return VoUtil.percentage(indexPvChange);
    }

    public Integer getIndexUv() {
        return indexUv;
    }

    public String getIndexUvChange() {
        return VoUtil.percentage(indexUvChange);
    }

    public Double getJoinRate() {
        return joinRate;
    }

    public String getJoinRateChange() {
        return VoUtil.percentage(joinRateChange);
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public String getSendPvChange() {
        return VoUtil.percentage(sendPvChange);
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public String getOpenPvChange() {
        return VoUtil.percentage(openPvChange);
    }

    public Double getSuccessRate() {
        return successRate;
    }

    public String getSuccessRateChange() {
        return VoUtil.percentage(successRateChange);
    }

    public Double getAndroidOpenRate() {
        return androidOpenRate;
    }

    public String getAndroidRateChange() {
        return VoUtil.percentage(androidRateChange);
    }

    public Double getIosOpenRate() {
        return iosOpenRate;
    }

    public String getIosRateChange() {
        return VoUtil.percentage(iosRateChange);
    }

    public Double getWebOpenRate() {
        return webOpenRate;
    }

    public String getWebRateChange() {
        return VoUtil.percentage(webRateChange);
    }

    public Double getWechatOpenRate() {
        return wechatOpenRate;
    }

    public String getWechatRateChange() {
        return VoUtil.percentage(wechatRateChange);
    }

    public Double getImeiOpenRate() {
        return imeiOpenRate;
    }

    public String getImeiRateChange() {
        return VoUtil.percentage(imeiRateChange);
    }

    public Double getOldRate() {
        return oldRate;
    }

    public String getOldRateChange() {
        return VoUtil.percentage(oldRateChange);
    }

    public Double getClickRate() {
        return clickRate;
    }

    public String getClickRateChange() {
        return VoUtil.percentage(clickRateChange);
    }

    public Double getPerOpenPv() {
        return perOpenPv;
    }

    public String getPerOpenPvChange() {
        return VoUtil.percentage(perOpenPvChange);
    }

    public Double getRptOpenPv() {
        return rptOpenPv;
    }

    public String getRptOpenPvChange() {
        return VoUtil.percentage(rptOpenPvChange);
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public void setIconClickPv(Integer iconClickPv) {
        this.iconClickPv = iconClickPv;
    }

    public void setIconClickChange(String iconClickChange) {
        this.iconClickChange = iconClickChange;
    }

    public Integer getMidPageUv() {
        return midPageUv;
    }

    public void setMidPageUv(Integer midPageUv) {
        this.midPageUv = midPageUv;
    }

    public Integer getMidPagePv() {
        return midPagePv;
    }

    public void setMidUvChange(String midUvChange) {
        this.midUvChange = midUvChange;
    }

    public void setMidPagePv(Integer midPagePv) {
        this.midPagePv = midPagePv;
    }

    public void setMidPvChange(String midPvChange) {
        this.midPvChange = midPvChange;
    }

    public void setIndexPv(Integer indexPv) {
        this.indexPv = indexPv;
    }

    public void setIndexPvChange(String indexPvChange) {
        this.indexPvChange = indexPvChange;
    }

    public void setIndexUv(Integer indexUv) {
        this.indexUv = indexUv;
    }

    public void setIndexUvChange(String indexUvChange) {
        this.indexUvChange = indexUvChange;
    }

    public void setJoinRate(Double joinRate) {
        this.joinRate = joinRate;
    }

    public void setJoinRateChange(String joinRateChange) {
        this.joinRateChange = joinRateChange;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public void setSendPvChange(String sendPvChange) {
        this.sendPvChange = sendPvChange;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public void setSuccessRate(Double successRate) {
        this.successRate = successRate;
    }

    public void setSuccessRateChange(String successRateChange) {
        this.successRateChange = successRateChange;
    }

    public void setAndroidOpenRate(Double androidOpenRate) {
        this.androidOpenRate = androidOpenRate;
    }

    public void setAndroidRateChange(String androidRateChange) {
        this.androidRateChange = androidRateChange;
    }

    public void setIosOpenRate(Double iosOpenRate) {
        this.iosOpenRate = iosOpenRate;
    }

    public void setIosRateChange(String iosRateChange) {
        this.iosRateChange = iosRateChange;
    }

    public void setWebOpenRate(Double webOpenRate) {
        this.webOpenRate = webOpenRate;
    }

    public void setWebRateChange(String webRateChange) {
        this.webRateChange = webRateChange;
    }

    public void setWechatOpenRate(Double wechatOpenRate) {
        this.wechatOpenRate = wechatOpenRate;
    }

    public void setWechatRateChange(String wechatRateChange) {
        this.wechatRateChange = wechatRateChange;
    }

    public void setImeiOpenRate(Double imeiOpenRate) {
        this.imeiOpenRate = imeiOpenRate;
    }

    public void setImeiRateChange(String imeiRateChange) {
        this.imeiRateChange = imeiRateChange;
    }

    public void setOldRate(Double oldRate) {
        this.oldRate = oldRate;
    }

    public void setOldRateChange(String oldRateChange) {
        this.oldRateChange = oldRateChange;
    }

    public void setClickRate(Double clickRate) {
        this.clickRate = clickRate;
    }

    public void setClickRateChange(String clickRateChange) {
        this.clickRateChange = clickRateChange;
    }

    public void setPerOpenPv(Double perOpenPv) {
        this.perOpenPv = perOpenPv;
    }

    public void setPerOpenPvChange(String perOpenPvChange) {
        this.perOpenPvChange = perOpenPvChange;
    }

    public void setRptOpenPv(Double rptOpenPv) {
        this.rptOpenPv = rptOpenPv;
    }

    public void setRptOpenPvChange(String rptOpenPvChange) {
        this.rptOpenPvChange = rptOpenPvChange;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public void setIncomeChange(String incomeChange) {
        this.incomeChange = incomeChange;
    }

    public void setDeveloperIncome(Double developerIncome) {
        this.developerIncome = developerIncome;
    }

    public void setDeveloperIncomeChange(String developerIncomeChange) {
        this.developerIncomeChange = developerIncomeChange;
    }

    public void setBxmIncome(Double bxmIncome) {
        this.bxmIncome = bxmIncome;
    }

    public void setBxmIncomeChange(String bxmIncomeChange) {
        this.bxmIncomeChange = bxmIncomeChange;
    }

    public void setOpenPvAurp(Double openPvAurp) {
        this.openPvAurp = openPvAurp;
    }

    public void setOpenPvAurpChange(String openPvAurpChange) {
        this.openPvAurpChange = openPvAurpChange;
    }

    public void setUvAurp(Double uvAurp) {
        this.uvAurp = uvAurp;
    }

    public void setUvAurpChange(String uvAurpChange) {
        this.uvAurpChange = uvAurpChange;
    }

    public void setDeveloperAurp(Double developerAurp) {
        this.developerAurp = developerAurp;
    }

    public void setDeveloperAurpChange(String developerAurpChange) {
        this.developerAurpChange = developerAurpChange;
    }

    public void setBxmAurp(Double bxmAurp) {
        this.bxmAurp = bxmAurp;
    }

    public void setBxmAurpChange(String bxmAurpChange) {
        this.bxmAurpChange = bxmAurpChange;
    }

    public void setBusinessIncome(Double businessIncome) {
        this.businessIncome = businessIncome;
    }

    public void setBusinessIncomeChange(String businessIncomeChange) {
        this.businessIncomeChange = businessIncomeChange;
    }

    public void setBusinessAurp(Double businessAurp) {
        this.businessAurp = businessAurp;
    }

    public void setBusinessAurpChange(String businessAurpChange) {
        this.businessAurpChange = businessAurpChange;
    }


    public Double getIncome() {
        return income;
    }

    public String getIncomeChange() {
        return VoUtil.percentage(incomeChange);
    }

    public Double getDeveloperIncome() {
        return developerIncome;
    }

    public String getDeveloperIncomeChange() {
        return VoUtil.percentage(developerIncomeChange);
    }

    public Double getBxmIncome() {
        return bxmIncome;
    }

    public String getBxmIncomeChange() {
        return VoUtil.percentage(bxmIncomeChange);
    }

    public Double getOpenPvAurp() {
        return VoUtil.getArpuOrEcpm(income, openPv);
    }

    public String getOpenPvAurpChange() {
        return VoUtil.percentage(openPvAurpChange);
    }

    public Double getUvAurp() {
        return uvAurp;
    }

    public String getUvAurpChange() {
        return VoUtil.percentage(uvAurpChange);
    }

    public Double getDeveloperAurp() {
        return developerAurp;
    }

    public String getDeveloperAurpChange() {
        return VoUtil.percentage(developerAurpChange);
    }

    public Double getBxmAurp() {
        return bxmAurp;
    }

    public String getBxmAurpChange() {
        return VoUtil.percentage(bxmAurpChange);
    }

    public Double getBusinessIncome() {
        return businessIncome;
    }

    public String getBusinessIncomeChange() {
        return VoUtil.percentage(businessIncomeChange);
    }

    public Double getBusinessAurp() {
        return businessAurp;
    }

    public String getBusinessAurpChange() {
        return VoUtil.percentage(businessAurpChange);
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Integer getJoinUv() {
        return joinUv;
    }

    public void setJoinUv(Integer joinUv) {
        this.joinUv = joinUv;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public Double getIncomeAurp() {
        return VoUtil.getArpuOrEcpm(income, indexUv);
    }

    public void setIncomeAurp(Double incomeAurp) {
        this.incomeAurp = incomeAurp;
    }

    public String getIncomeAurpChange() {
        return incomeAurpChange;
    }

    public void setIncomeAurpChange(String incomeAurpChange) {
        this.incomeAurpChange = incomeAurpChange;
    }

    public Integer getIconPv() {
        return iconPv;
    }

    public void setIconPv(Integer iconPv) {
        this.iconPv = iconPv;
    }

    public Double getMidPageRate() {
        return midPageRate;
    }

    public void setMidPageRate(Double midPageRate) {
        this.midPageRate = midPageRate;
    }

    public Integer getLandingPagePv() {
        return landingPagePv;
    }

    public void setLandingPagePv(Integer landingPagePv) {
        this.landingPagePv = landingPagePv;
    }

    public Double getLandingPageRate() {
        return landingPageRate;
    }

    public void setLandingPageRate(Double landingPageRate) {
        this.landingPageRate = landingPageRate;
    }

    //券收入除以广告位曝光数
    public Double getEcpm() {
        return VoUtil.getArpuOrEcpm(income, iconPv) * 1000;
    }

    public void setEcpm(Double ecpm) {
        this.ecpm = ecpm;
    }

    //子链接收益除以广告位曝光数
    public Double getmEcpm() {
        return VoUtil.getArpuOrEcpm(businessIncome, iconPv) * 1000;
    }

    public void setmEcpm(Double mEcpm) {
        this.mEcpm = mEcpm;
    }

    public String getIconChange() {
        return VoUtil.percentage(incomeChange);
    }

    public void setIconChange(String iconChange) {
        this.iconChange = iconChange;
    }

    public String getMidPageRateChange() {
        return midPageRateChange;
    }

    public void setMidPageRateChange(String midPageRateChange) {
        this.midPageRateChange = midPageRateChange;
    }

    public String getLandingPageChange() {
        return VoUtil.percentage(landingPageChange);
    }

    public void setLandingPageChange(String landingPageChange) {
        this.landingPageChange = landingPageChange;
    }

    public String getLandingRateChange() {
        return landingRateChange;
    }

    public void setLandingRateChange(String landingRateChange) {
        this.landingRateChange = landingRateChange;
    }

    public String getEcpmChange() {
        return VoUtil.percentage(ecpmChange);
    }

    public void setEcpmChange(String ecpmChange) {
        this.ecpmChange = ecpmChange;
    }

    public String getmEcpmChange() {
        return VoUtil.percentage(ecpmChange);
    }

    public void setmEcpmChange(String mEcpmChange) {
        this.mEcpmChange = mEcpmChange;
    }

    //子链接uvArpu = 子链接收益/活动首页uv
    public Double getBussinessUvArpu() {
        return VoUtil.getArpuOrEcpm(businessIncome, indexUv);
    }

    public void setBussinessUvArpu(Double bussinessUvArpu) {
        this.bussinessUvArpu = bussinessUvArpu;
    }

    //券收入uvArpu = 券收入/活动首页uv
    public Double getIncomeUvArpu() {
        return VoUtil.getArpuOrEcpm(income, indexUv);
    }

    public void setIncomeUvArpu(Double incomeUvArpu) {
        this.incomeUvArpu = incomeUvArpu;
    }

    public Double getPerClickPv() {
        return perClickPv;
    }

    public void setPerClickPv(Double perClickPv) {
        this.perClickPv = perClickPv;
    }

    public Double getPerClickPvChange() {
        return perClickPvChange;
    }

    public void setPerClickPvChange(Double perClickPvChange) {
        this.perClickPvChange = perClickPvChange;
    }

    public Double getIconClickPvRate() {
        return iconClickPvRate;
    }

    public void setIconClickPvRate(Double iconClickPvRate) {
        this.iconClickPvRate = iconClickPvRate;
    }

    public String getIconClickPvRateChange() {
        return VoUtil.percentage(iconClickPvRateChange);
    }

    public void setIconClickPvRateChange(String iconClickPvRateChange) {
        this.iconClickPvRateChange = iconClickPvRateChange;
    }

    public String getPositionId() {
        String positionIdTmp = "";
        if (StringUtils.isNotBlank(this.business)) {
            positionIdTmp = this.appKey + "-" + this.business.replace("ad-", "");
        }
        return positionId = positionIdTmp;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    /**
     * 分成比例=开发者收益/券收入*100%
     */
    public String getDividePercent() {
        /*if (null==developerIncome || null==income){
            return "0.00%";
        }
        return VoUtil.formatDouble((developerIncome/income)*100)+"%";*/
        return dividePercent;
    }

    public void setDividePercent(String dividePercent) {
        this.dividePercent = dividePercent;
    }

    public String getDividePercentChange() {
        return dividePercentChange;
    }

    public void setDividePercentChange(String dividePercentChange) {
        this.dividePercentChange = dividePercentChange;
    }

    public Integer getTicket_num() {
        return ticket_num;
    }

    public void setTicket_num(Integer ticket_num) {
        this.ticket_num = ticket_num;
    }
}
