package com.bxm.datapark.facade.app.model.vo;

import java.io.Serializable;

/**
* @Title:AppCommonVo.java
* @Package:com.bxm.datapark.facade.app.model.vo
* @Description: 媒体相关公共类
* @date:2018年12月14日 上午9:17:14
* @author wangchao
 */
public class AppCommonVo implements Serializable {

    private static final long serialVersionUID = -3463041482911221476L;
    
    /**
     * 媒体类型名称
     */
    private String mediaTypeName;
    
    /**
     * 广告位分类
     */
    private String mediaJoinClassName;
    
    /**
     * 媒体分类名称
     */
    private String mediaClass;

    /**
     * 媒体子分类名称
     */
    private String mediaChildClass;

    public String getMediaTypeName() {
        return mediaTypeName;
    }

    public void setMediaTypeName(String mediaTypeName) {
        this.mediaTypeName = mediaTypeName;
    }

    public String getMediaClass() {
        return mediaClass;
    }

    public void setMediaClass(String mediaClass) {
        this.mediaClass = mediaClass;
    }

    public String getMediaChildClass() {
        return mediaChildClass;
    }

    public void setMediaChildClass(String mediaChildClass) {
        this.mediaChildClass = mediaChildClass;
    }
    
    public String getMediaJoinClassName() {
        return (mediaClass + "/" + mediaChildClass).replace("null","");
    }

    public void setMediaJoinClassName(String mediaJoinClassName) {
        this.mediaJoinClassName = mediaJoinClassName;
    }
}
