package com.bxm.datapark.web;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.web.model.AssemblyData;
import com.bxm.datapark.web.model.AssemblyDataDTO;
import com.bxm.datapark.web.model.AssemblyRefundData;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;


/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/2/12 09:44
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadeAssemblyDataService {

    @RequestMapping("/data/assembly/position")
    public ResultModel<Page<AssemblyData>> getAssemblyData(@RequestBody AssemblyDataDTO search);

    @RequestMapping("/data/assembly/refund")
    public ResultModel<Page<AssemblyRefundData>> getAssemblyRefundData(@RequestBody AssemblyDataDTO search);

}
