package com.bxm.datapark.web;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ocpc.OcpcStageCpaSearchDto;
import com.bxm.datapark.facade.ocpc.OcpcStageCpaVo;
import com.bxm.datapark.facade.ocpc.OcpcStatistics;
import com.bxm.datapark.facade.ocpc.OcpcStatisticsCondition;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * <h3>活动相关的数据</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/11/11 14:01
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadeOcpcDataServive {

    @RequestMapping("/data/ticket/ocpc/find")
    public Page<OcpcStatistics> find(@RequestBody OcpcStatisticsCondition condition);


    /**
     * 查找ocpc二阶段的消耗、有效点击、平均cpa
     * @param search
     * @return
     */
    @RequestMapping("/data/ticket/ocpc/getSecondStageAvgCpa")
    List<OcpcStageCpaVo> getOcpcSecondStageAvgCpa(@RequestBody OcpcStageCpaSearchDto search);


}
