package com.bxm.datapark.web.model;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/2/12 09:47
 */
@Data
public class AssemblyData implements Serializable {
    private static final long serialVersionUID = 603702740176512921L;
    private int id;
    /**
     * 广告位id
     */
    private String positionId;
    /**
     * 曝光数
     */
    private Integer exposureView = 0;
    /**
     * 点击数
     */
    private Integer clickView = 0;
    /**
     * 统计日期
     */
    private String settleDate;
    /**
     * 支付订单数
     */
    private Integer orderNum;
    /**
     * 订单总数
     */
    private Integer totalNum;
    /**
     * 付费转化率
     */
    private Double payRate;
    /**
     * 预估收益：单位分
     */
    private Integer forecastEarnings;
    /**
     * 组件id
     */
    private Integer pid;
    private Date createTime;

}
