package com.bxm.datapark.web.model;

import java.io.Serializable;
import java.util.List;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/2/12 09:47
 */

public class AssemblyDataDTO implements Serializable {

    private static final long serialVersionUID = 8503702740176512921L;

    public static final byte NONE = 0;
    public static final byte DATETIME = 1;
    public static final byte POSTION = 2;
    public static final byte ALL =3;

    private int id;
    /**
     * 广告位id
     */
    private List<String> positionIds;

    /**
     * 统计日期
     */
    private String settleDate;

    /**
     * 组件id
     */
    private List<Integer> pids;

    private String startDate;
    private String endDate;
    private Integer pageNum = 1;
    private Integer pageSize = 20;
    /**
     * 数据库查询字段
     */
    private Integer pageNo ;
    /**
     * 0, 不分维度
     * 1, 按天维度查询
     * 2, 按广告位维度查询
     * 3, 查询汇总数据
     */
    private byte group = NONE;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<String> getPositionIds() {
        return positionIds;
    }

    public void setPositionIds(List<String> positionIds) {
        this.positionIds = positionIds;
    }

    public String getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(String settleDate) {
        this.settleDate = settleDate;
    }

    public List<Integer> getPids() {
        return pids;
    }

    public void setPids(List<Integer> pids) {
        this.pids = pids;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNo() {
        if (pageNum -1 <0){
            return 0;
        }
        return pageNum -1 ;
    }

    public byte getGroup() {
        return group;
    }

    public void setGroup(byte group) {
        this.group = group;
    }
}
