/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with http://www.bianxianmao.com.
 */

package com.bxm.datapark.web.model.old.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 广告券属性枚举
 *
 * @author 阿导
 * @version v1.1.4_Report
 * @fileName com.bxm.datapark.model.mongo.enums.TicketFiledEnum.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-28 17:08:00
 * @modifier 阿导
 * @updated 2018-02-28 17:08:00
 */
public enum TicketFiledEnum {


    /**
     * 小时
     */
    HOURS("hours","hours"),
    /**
     * 券id
     */
    CERTIFICATEID("certificateid","certificate_id"),
    /**
     * 是否是首张弹券
     */
    SCENE("scene","scene"),



    /**
     * appkey
     */
    APPKEY("appkey","app_key"),


    /**
     * 子渠道标志
     */
    BUSINESS("business","business"),


    /**
     * 发券请求
     */
    SEND_PV("sendPv","send_pv"),

    /**
     * 点击量
     */
    CLICK_PV("clickPv","click_pv"),

    /**
     * 曝光量（发券量）
     */
    OPEN_PV("openPv","open_pv"),
    /**
     * 曝光量（发券量）涨幅
     */
    OPEN_PV_CHANGE("openPv","open_pv_change"),

    /**
     * 有效点击量
     */
    VALID_CLICK_PV("validClick","valid_click_pv"),

    /**
     * 有效点击率
     */
    VALID_RATE("validClickRate","valid_rate"),
    VALID_RATE_SHOW("validClickRateShow","valid_rate"),

    /**
     * 转化率
     */
    CLICK_RATE("conversion","click_rate"),
    CLICK_RATE_SHOW("conversionShow","click_rate"),

    /**
     * 券收入
     */
    INCOME("income","income"),
    /**
     * 券消耗
     */
    CONSUME("consume","consume"),

    /**
     * 券收入涨幅
     */
    INCOME_CHANGE("incomeChange","income_change"),


    /**
     * 发券arpu
     */
    OPEN_PV_ARPU("openPvAurp","open_pv_arpu"),
    /**
     * 发券arpu涨幅
     */
    OPEN_PV_ARPU_CHANGE("openPvAurpChange","open_pv_arpu_change"),
    /**
     * 点击arpu
     */
    CLICK_ARPU("clickAurp","click_arpu"),
    /**
     * 点击arpu涨幅
     */
    CLICK_ARPU_CHANGE("clickAurpChange","click_arpu_change"),
    /**
     * 有效点击率占比
     */
    QUALITY_FACTOR("qualityFactor","quality_factor"),
    QUALITY_FACTOR_SHOW("qualityFactorShow","quality_factor"),



    /**
     * 发券占比(主要用于排序，发券占比排序，其实就是发券量排序)
     */
    OPEN_PV_RATE("openPvRate","certificate_open_rate"),
    OPEN_PV_RATE_SHOW("openPvRateShow","certificate_open_rate"),


    EXPOSURE_PV("exposurePv","exposure_pv"),
    /**
     * 曝光成功率
     */
    EXPOSURE_RATE("exposureRate","exposure_rate"),
    EXPOSURE_RATE_SHOW("exposureRateShow","exposure_rate"),

    /**
     * 总发券机会
     */
    TOTAL_SEND_TICKET_PROBABLITY("totalSendTicketProbability","total_opening_chance"),

    /**
     * 礼券日平均权重
     */
    AVERAGE_WEIGHT_BY_DAY( "averageWeightByDay","average_weight"),

   /**
   * 首页活动UV
    * */
    INDEX_UV("indexUv","index_uv"),
    /**
     * 首页活动涨幅
     * */
    INDEX_UV_CHANGE("indexUvChange","index_uv_change"),
    /**
     * 人均发券
     * */
    PER_OPEN_PV("perOpenPv","per_open_pv"),
    /**
     * 人均发券涨幅
     * */
    PER_OPEN_PV_CHANGE("perOpenPvChange","per_open_pv_change"),
    /**
     * 人均券点击
     * */
    PER_CLICK_PV("perClickPv","per_click_pv"),
    /**
     * 人均券点击涨幅
     * */
    PER_CLICK_PV_CHANGE("perClickPvChange","per_click_pv_change");


    private String code;

    private String name;

    TicketFiledEnum(String code, String name){
        this.code = code;
        this.name = name;
    }

    /**
     * @return the code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }


    /**
     * 所有状态
     *
     * @return
     */
    public static Map<String, String> getAllState() {
        TicketFiledEnum[] sts = TicketFiledEnum.values();
        Map<String, String> maps = new HashMap<String, String>();
        for (TicketFiledEnum tmp : sts) {
            maps.put(tmp.code, tmp.name);
        }
        return maps;
    }

    /**
     * 根据code得到name
     *
     * @param code
     * @return
     */
    public static String getName(String code) {
        try{
            for (TicketFiledEnum state : TicketFiledEnum.values()) {
                if (state.getCode().equals(code)) {
                    return state.getName();
                }
            }
        }catch (Exception e){
            return "";
        }
        return "not find enum";
    }

}
