/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with http://www.bianxianmao.com.
 */

package com.bxm.datapark.web.model.old.vo.newad;

import com.bxm.util.dto.VoUtil;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;

/**
 * 活动报表实体类
 *
 * @author 阿导
 * @version BUILD1001
 * @fileName com.bxm.datapark.model.mongo.vo.newad.ActivityCount.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-07 09:43:00
 * @modifier 阿导
 * @updated 2018-02-07 09:43:00
 */
public class ActivityCount implements Serializable {


    private static final long serialVersionUID = -619641241814650416L;

    /**
     * 编号
     */
    private String number;
    /**
     * 日期
     */

    private String datetime;
    /**
     * 活动 ID
     */

    @Field("activity_id")
    private Long activityId;

    /**
     * 开发者标志
     */

    @Field("app_key")
    private String appKey;

    /**
     * 子渠道标志
     */

    @Field("business")
    private String business;

    /**
     * 活动首页 PV
     */

    @Field("index_pv")
    private Integer indexPv;

    /**
     * 活动首页 PV 涨幅
     */

    @Field("index_pv_change")
    private String indexPvChange;

    /**
     * 活动首页 UV
     */

    @Field("index_uv")
    private Integer indexUv;

    /**
     * 活动首页 UV 涨幅
     */

    @Field("index_uv_change")
    private String indexUvChange;

    /**
     * 参与次数
     */
    @Field("join_pv")
    private Integer joinPv;


    /**
     * 参与次数涨幅
     */
    @Field("join_pv_change")
    private String joinPvChange;

    /**
     * 参与次数
     */
    @Field("join_uv")
    private Integer joinUv;

    /**
     * 参与次数涨幅
     */

    @Field("join_uv_change")
    private String joinUvChange;

    /**
     * 参与率
     */
    @Field("join_rate")
    private Double joinRate;

    /**
     * 参与率涨幅
     */

    @Field("join_rate_change")
    private String joinRateChange;

    /**
     * 发券请求
     */

    @Field("send_pv")
    private Integer sendPv;
    /**
     * 发券请求涨幅
     */

    @Field("send_pv_change")
    private String sendPvChange;


    /**
     * 人均发券
     */

    @Field("per_open_pv")
    private Double avgCoupons;

    /**
     * 人均发券涨幅
     */

    @Field("per_open_pv_change")
    private String avgCouponsChange;

    /**
     * 重复发券
     */

    @Field("rpt_open_pv")
    private Double repeatCoupons;

    /**
     * 发券成功率
     */

    @Field("activity_success_rate")
    private Double activitySuccessRate ;

    /**
     * 发券成功率涨幅
     */
    @Field("activity_success_rate_change")
    private String activitySuccessRateChange = "0%";

    /**
     * 重复发券涨幅
     */
    @Field("rpt_open_pv_change")
    private String repeatCouponsChange;

    /**
     * 发券量
     */
    @Field("open_pv")
    private Integer openPv;

    /**
     * 发券量涨幅
     */
    @Field("open_pv_change")
    private String openPvChange;

    /**
     * 点击量
     */
    @Field("click_pv")
    private Integer clickPv;

    /**
     * 点击量涨幅
     */
    @Field("click_pv_change")
    private String clickPvChange;
    /**
     * 人均点击量=人均券点击
     */
    @Field("per_click_pv")
    private Double perClickPv;
    /**
     * 人均点击量环比昨日
     */
    @Field("per_click_pv_change")
    private Double perClickPvChange;
    /**
     *活动类型
     */
    @Field("activity_type")
    private String activityType;
    /**
     *活动策划
     */
    @Field("activity_planner")
    private String activityPlanner;
    /**
     * 券点击率
     * */
    @Field("click_rate")
    private Double clickRate;

    @Field("click_rate_change")
    private String clickRateChange;

    /**
     * 活动到达率
     */
    @Field("landing_page_rate")
    private Double landingPageRate;

    /**
     * 活动到达率涨幅
     */
    @Field("landing_page_rate_change")
    private String landingPageRateChange;

    /**
     * 中间页跳转活动首页pv
     */
    @Field("landing_page_pv")
    private Integer landingPagePv;

    /**
     * 中间页pv
     */
    @Field("mid_page_pv")
    private Integer midPagePv;

    public Integer getLandingPagePv() {
        return landingPagePv;
    }

    public void setLandingPagePv(Integer landingPagePv) {
        this.landingPagePv = landingPagePv;
    }

    public Integer getMidPagePv() {
        return midPagePv;
    }

    public void setMidPagePv(Integer midPagePv) {
        this.midPagePv = midPagePv;
    }

    public Double getLandingPageRate() {
        return landingPageRate;
    }

    public void setLandingPageRate(Double landingPageRate) {
        this.landingPageRate = landingPageRate;
    }

    public String getLandingPageRateChange() {
        return landingPageRateChange;
    }

    public void setLandingPageRateChange(String landingPageRateChange) {
        this.landingPageRateChange = landingPageRateChange;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public Integer getIndexPv() {
        return indexPv;
    }

    public void setIndexPv(Integer indexPv) {
        this.indexPv = indexPv;
    }

    public String getIndexPvChange() {
        return VoUtil.percentage(indexPvChange);
    }

    public void setIndexPvChange(String indexPvChange) {
        this.indexPvChange = indexPvChange;
    }

    public Integer getIndexUv() {
        return indexUv;
    }

    public void setIndexUv(Integer indexUv) {
        this.indexUv = indexUv;
    }

    public String getIndexUvChange() {
        return VoUtil.percentage(indexUvChange);
    }

    public void setIndexUvChange(String indexUvChange) {
        this.indexUvChange = indexUvChange;
    }

    public Integer getJoinPv() {
        return joinPv;
    }

    public void setJoinPv(Integer joinPv) {
        this.joinPv = joinPv;
    }

    public String getJoinPvChange() {
        return VoUtil.percentage(joinPvChange);
    }

    public void setJoinPvChange(String joinPvChange) {
        this.joinPvChange = joinPvChange;
    }

    public Integer getJoinUv() {
        return joinUv;
    }

    public void setJoinUv(Integer joinUv) {
        this.joinUv = joinUv;
    }

    public String getJoinUvChange() {
        return VoUtil.percentage(joinUvChange);
    }

    public void setJoinUvChange(String joinUvChange) {
        this.joinUvChange = joinUvChange;
    }

    public Double getJoinRate() {
        return joinRate;
    }

    public void setJoinRate(Double joinRate) {
        this.joinRate = joinRate;
    }

    public String getJoinRateChange() {
        return VoUtil.percentage(joinRateChange);
    }

    public void setJoinRateChange(String joinRateChange) {
        this.joinRateChange = joinRateChange;
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public String getSendPvChange() {
        return VoUtil.percentage(sendPvChange);
    }

    public void setSendPvChange(String sendPvChange) {
        this.sendPvChange = sendPvChange;
    }

    public Double getAvgCoupons() {
        return avgCoupons;
    }

    public void setAvgCoupons(Double avgCoupons) {
        this.avgCoupons = avgCoupons;
    }

    public String getAvgCouponsChange() {
        return VoUtil.percentage(avgCouponsChange);
    }

    public void setAvgCouponsChange(String avgCouponsChange) {
        this.avgCouponsChange = avgCouponsChange;
    }

    public Double getRepeatCoupons() {
        return repeatCoupons;
    }

    public void setRepeatCoupons(Double repeatCoupons) {
        this.repeatCoupons = repeatCoupons;
    }

    public String getRepeatCouponsChange() {
        return VoUtil.percentage(repeatCouponsChange);
    }

    public void setRepeatCouponsChange(String repeatCouponsChange) {
        this.repeatCouponsChange = repeatCouponsChange;
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public String getOpenPvChange() {
        return VoUtil.percentage(openPvChange);
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public String getClickPvChange() {
        return VoUtil.percentage(clickPvChange);
    }

    public void setClickPvChange(String clickPvChange) {
        this.clickPvChange = clickPvChange;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Double getActivitySuccessRate() {
        return activitySuccessRate;
    }

    public void setActivitySuccessRate(Double activitySuccessRate) {
        this.activitySuccessRate = activitySuccessRate;
    }

    public String getActivitySuccessRateChange() {
        return VoUtil.percentage(activitySuccessRateChange);
    }

    public void setActivitySuccessRateChange(String activitySuccessRateChange) {
        this.activitySuccessRateChange = activitySuccessRateChange;
    }

    public Double getPerClickPv() {
        return perClickPv;
    }

    public void setPerClickPv(Double perClickPv) {
        this.perClickPv = perClickPv;
    }

    public Double getPerClickPvChange() {
        return perClickPvChange;
    }

    public void setPerClickPvChange(Double perClickPvChange) {
        this.perClickPvChange = perClickPvChange;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getActivityPlanner() {
        return activityPlanner;
    }

    public void setActivityPlanner(String activityPlanner) {
        this.activityPlanner = activityPlanner;
    }

    public Double getClickRate() {
        return clickRate;
    }

    public void setClickRate(Double clickRate) {
        this.clickRate = clickRate;
    }

    public String getClickRateChange() {
        return VoUtil.percentage(clickRateChange);
    }

    public void setClickRateChange(String clickRateChange) {
        this.clickRateChange = clickRateChange;
    }
}
