package com.bxm.datapark.facade.ocpc;

import java.util.List;

import org.apache.commons.lang.StringUtils;


/**
 * @author allen
 * @since 1.0.0
 */
public class OcpcStatisticsCondition extends OcpcStatistics {

    private static final long serialVersionUID = -2970201143899712835L;
    public static final String SORT_ASC = "asc";
    public static final String SORT_DESC = "desc";

    private String date;
    private String keyword;

    private String sortName;
    private Integer pageNum = 1;
    private Integer pageSize = 20;
    private String sortType;

    private String ticketIds;

    private List<Integer> ticketIdList;
    
    private List<String> positionIdList;

    public boolean isAscending() {
        return StringUtils.equals(SORT_ASC, sortType);
    }

    public boolean isDescending() {
        return StringUtils.equals(SORT_DESC, sortType);
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getSortName() {
        return sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getTicketIds() {
        return ticketIds;
    }

    public void setTicketIds(String ticketIds) {
        this.ticketIds = ticketIds;
    }

    public List<String> getPositionIdList() {
        return positionIdList;
    }

    public void setPositionIdList(List<String> positionIdList) {
        this.positionIdList = positionIdList;
    }

    public List<Integer> getTicketIdList() {
        return ticketIdList;
    }

    public void setTicketIdList(List<Integer> ticketIdList) {
        this.ticketIdList = ticketIdList;
    }
}

