package com.bxm.datapark.facade.ticket.service;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bxm.warcar.utils.response.ResultModel;

/**
 * <p>
 * 个推标签数据
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-12-03
 */
@FeignClient(name="datapark")
public interface GetuiTagDataService {

    /**
     * 根据标签获得覆盖率数据
     *
     * @param tags 一个元素为一组标签，一组标签内有多个用逗号分隔
     * @return
     */
    @RequestMapping(value = "/getui/tag/converage", method = RequestMethod.POST)
    ResultModel<Long> getConverage(@RequestBody List<String> tags);

}
