package com.bxm.datapark.web;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.web.model.SspPositionFinanceDaily;
import com.bxm.warcar.utils.response.ResultModel;

/**
 * <h3>活动相关的数据</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/11/11 14:01
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadeSspPositionDataServive {

    /**
     * 广告位收益
     * @param search
     * @return
     */
    @RequestMapping("/data/ssp/position")
    ResultModel<List<SspPositionFinanceDaily>> getPositionDspData(@RequestBody SspPositionFinanceDaily search);

    /**
     * 广告位收益(API对接的)
     * @param search
     * @return
     */
    @RequestMapping("/data/ssp/positionForApi")
    ResultModel<List<SspPositionFinanceDaily>> getPositionDspDataForApi(@RequestBody SspPositionFinanceDaily search);

    /**
     * 聚合广告位收益
     * @param search
     * @return
     */
    @RequestMapping("/data/ssp/collectionPosition")
    ResultModel<List<SspPositionFinanceDaily>> getCollectionPositionDspData(@RequestBody SspPositionFinanceDaily search);

    /**
     * 新版本需求    不管sdk 还是api 对接方式  收益数据改为这个方法
     * @param search
     * @return
     */
    @RequestMapping("/data/ssp/positionForSdkAndApi")
    ResultModel<List<SspPositionFinanceDaily>> getPositionDspDataForSdkAndApi(@RequestBody SspPositionFinanceDaily search);
}
