package com.bxm.datapark.web;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.datapark.DataParkConstants;
import com.bxm.warcar.utils.response.ResultModel;

/**
 * <p>
 * SSP各app日活数据
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-12-08
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadeSspSdkAppDailyDataServive {

    /**
     * 查询SDK日活
     * @param date yyyy-dd-mm
     * @return
     */
    @RequestMapping(value = "/data/ssp/sdk/daily/dau", method = RequestMethod.GET)
    ResultModel<Long> getSdkDau(@RequestParam("date") String date);
}
