package com.bxm.datapark.web;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.web.model.ThridRequestDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2021/3/18 15:51
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface ThridDataScoreService {

    @RequestMapping(value = "/third/ticketScore", method = RequestMethod.POST)
    public ResponseEntity ticketScore(@RequestBody ThridRequestDTO requestDTO);

    @RequestMapping(value = "/third/ticketDatahour", method = RequestMethod.POST)
    public ResponseEntity<ThridRequestDTO> ticketDataHour(@RequestBody ThridRequestDTO requestDTO);

    @RequestMapping(value = "/third/ticketData", method = RequestMethod.POST)
    public ResponseEntity<ThridRequestDTO> ticketData(@RequestBody ThridRequestDTO requestDTO);
}
