package com.bxm.datapark.web.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * tbl_duoyou_award_log
 * @author
 */
public class DuoyouAwardLog implements Serializable {
    private Integer id;

    /**
     * 奖励订单号
     */
    private String orderId;

    /**
     * 广告ID
     */
    private Integer advertId;

    /**
     * 广告名称
     */
    private String advertName;

    /**
     * 媒体广告收益（不含用户奖励部分）
     */
    private BigDecimal mediaIncome;

    /**
     * 媒体用户奖励
     */
    private BigDecimal memberIncome;

    /**
     * 媒体主用户UID（APP用户UID）
     */
    private String mediaId;

    /**
     * 媒体主用户UID（APP用户UID）
     */
    private String userId;

    /**
     * 设备号，安卓系统设备imei
     */
    private String deviceId;

    /**
     * 备注内容
     */
    private String content;

    /**
     * 扩展字段 json格式
     */
    private String extra;

    /**
     * 奖励配置ID
     */
    private Integer ruleId;

    /**
     * 游戏类型 2、手游，3、益智
     */
    private Integer gameType;

    /**
     * 游戏图标
     */
    private String icon;

    /**
     * 是否属于快赚奖励
     */
    private String isFastEarn;

    /**
     * 奖励类型，当前可能值[试玩,充值,榜单,红包]
     */
    private String awardType;

    /**
     * 游戏是否支持att（ios游戏专用）
     */
    private Integer iosAtt;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 订单创建时间
     */
    private Date created;

    private static final long serialVersionUID = 1L;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Integer getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Integer advertId) {
        this.advertId = advertId;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public BigDecimal getMediaIncome() {
        return mediaIncome;
    }

    public void setMediaIncome(BigDecimal mediaIncome) {
        this.mediaIncome = mediaIncome;
    }

    public BigDecimal getMemberIncome() {
        return memberIncome;
    }

    public void setMemberIncome(BigDecimal memberIncome) {
        this.memberIncome = memberIncome;
    }

    public String getMediaId() {
        return mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public Integer getRuleId() {
        return ruleId;
    }

    public void setRuleId(Integer ruleId) {
        this.ruleId = ruleId;
    }

    public Integer getGameType() {
        return gameType;
    }

    public void setGameType(Integer gameType) {
        this.gameType = gameType;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIsFastEarn() {
        return isFastEarn;
    }

    public void setIsFastEarn(String isFastEarn) {
        this.isFastEarn = isFastEarn;
    }

    public String getAwardType() {
        return awardType;
    }

    public void setAwardType(String awardType) {
        this.awardType = awardType;
    }

    public Integer getIosAtt() {
        return iosAtt;
    }

    public void setIosAtt(Integer iosAtt) {
        this.iosAtt = iosAtt;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public Date getCreated() {
        return created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }
}