package com.bxm.datapark.web.model;

import java.io.Serializable;

/**
 * <p>
 * SSP场景DSP活动数据
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-08-13
 */
public class SspActivity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 投放控制，6为SDK活动
     */
    public static final int LAUNCH_CONTROL_SDK_ACTIVITY = 6;
    /**
     * 投放控制，7为复合活动
     */
    public static final int LAUNCH_CONTROL_COMPOUND_ACTIVITY = 7;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动地址
     */
    private String activityUrl;

    /**
     * 广告位配置json格式
     * [
     *     {
     *         "id": 1,
     *         "positionScene": 1,
     *         "informationFlowTemplate": 2,
     *         "positionId": 804434342111
     *     },
     *     {
     *         "id": 2,
     *         "positionScene": 3,
     *         "informationFlowTemplate": null,
     *         "positionId": 804434342754
     *     }
     * ]
     */
    private String positionConfig;

    /**
     * 活动状态，1为开启
     */
    private Integer activityState = 1;

    /**
     * 投放控制，6为SDK活动
     */
    private Integer launchControl = LAUNCH_CONTROL_SDK_ACTIVITY;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityUrl() {
        return activityUrl;
    }

    public void setActivityUrl(String activityUrl) {
        this.activityUrl = activityUrl;
    }

    public String getPositionConfig() {
        return positionConfig;
    }

    public void setPositionConfig(String positionConfig) {
        this.positionConfig = positionConfig;
    }

    public Integer getActivityState() {
        return activityState;
    }

    public void setActivityState(Integer activityState) {
        this.activityState = activityState;
    }

    public Integer getLaunchControl() {
        return launchControl;
    }

    public void setLaunchControl(Integer launchControl) {
        this.launchControl = launchControl;
    }
}
