package com.bxm.datapark.web.model.old.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/10 10:52
 * 修 改 人：
 * 日 期：
 * 描 述： 数据统计相关 字段对应
 * 版 本 号： v1
 */
public enum AnalysisFieldEnum {

    /**
     * 媒体ID
     */
    APP_KEY("appKey", "app_key"),

    /**
     * 广告位ID
     */
    POSITION_ID("positionId", "position_id"),

    /**
     * 广告ID
     */
    TICKET_ID("ticketId", "ticket_id"),

    /**
     * 发券数
     */
    OPEN_PV("openPV", "open_pv"),

    /**
     * 点击数
     */
    CLICK_PV("clickPV", "click_pv"),

    /**
     * 效果检测数
     */
    PAGE_EXPOSURE_PV("pageExposurePV", "page_exposure_pv"),

    /**
     * 广告总收入
     */
    INCOME("income", "income"),

    /**
     * 创建时间
     */
    CREATE_TIME("createTime", "create_time"),

    /**
     * 小时
     */
    HOUR("hour", "hour"),

    /**
     * 广告券一级标签
     */
    AD_TYPE_CODE("adTypeCode", "ad_type_code"),

    /**
     * 省份
     */
    PROVINCE("province", "province"),

    /**
     * 市区
     */
    CITY("city", "city"),

    /**
     * 手机操作系统
     */
    APP_OS("appOS", "app_os"),

    /**
     * 支付类型
     */
    UA("ua", "ua");

    private String classField;
    private String mongoField;

    AnalysisFieldEnum(String classField, String mongoField) {
        this.classField = classField;
        this.mongoField = mongoField;
    }

    public String getClassField() {
        return classField;
    }

    public void setClassField(String classField) {
        this.classField = classField;
    }

    public String getMongoField() {
        return mongoField;
    }

    public void setMongoField(String mongoField) {
        this.mongoField = mongoField;
    }

    public static AnalysisFieldEnum get(String classField) {
        if (StringUtils.isBlank(classField)) {
            return null;
        }
        for (AnalysisFieldEnum analysisFieldEnum : AnalysisFieldEnum.values()) {
            if (analysisFieldEnum.getClassField().equals(classField)) {
                return analysisFieldEnum;
            }
        }
        return null;
    }

}
