/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with http://www.bianxianmao.com.
 */

package com.bxm.datapark.web.model.old.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @detail 活动报表字段
 * @time 2018年2月23日10:52:14
 * @author 董朱旭
 */
public enum AppFiledEnum {


    /**
     * 开发者标志
     */
    APP_KEY("appKey","app_key"),
    POSITION_ID("positionid","positionid"),
    WARN_HANDLE_NAME("warn_handle_name","warn_handle_name"),
    /**
     * 子渠道标志
     */
    BUSINESS("business","business"),

    /**
     * 入口点击量(广告位点击量)
     */
    ICON_CLICK_PV("iconClickPv","icon_click_pv"),
    /**
     * 中间页uv
     */
    MID_PAGE_UV("midPageUv","mid_page_uv"),
    /**
     * 中间页pv
     */
    MID_PAGE_PV("midPagePv","mid_page_pv"),
    /**
     * 首页 PV
     */
    INDEX_PV("indexPv","index_pv"),
    /**
     * 首页 UV
     */
    INDEX_UV("indexUv","index_uv"),

    /**
     * 参与次数
     */
    JOIN_PV("joinPv","join_pv"),
    /**
     * 参与人数
     */
    JOIN_UV("joinUv","join_uv"),
    /**
     * 参与率
     */
    JOIN_RATE("joinRate","join_rate"),
    JOIN_RATE_SHOW("joinRateShow","join_rate"),
    /**
     * 发券请求
     */
    SEND_PV("sendPv","send_pv"),


    /**
     * 发券量
     */
    OPEN_PV("openPv","open_pv"),
    /**
     * 发券成功率
     */
    SUCCESS_RATE("successRate","success_rate"),
    SUCCESS_RATE_SHOW("successRateShow","success_rate"),
    /**
     * 安卓发券占比
     */
    ANDROID_OPEN_RATE("androidOpenRate","android_open_rate"),
    ANDROID_OPEN_RATE_SHHOW("androidOpenRateShow","android_open_rate"),
    /**
     * ios发券占比
     */
    IOS_OPEN_RATE("iosOpenRate","ios_open_rate"),
    IOS_OPEN_RATE_SHOW("iosOpenRateShow","ios_open_rate"),

    /**
     * web发券占比
     */
    WEB_OPEN_RATE("webOpenRate","web_open_rate"),
    WEB_OPEN_RATE_SHOW("webOpenRateShow","web_open_rate"),
    /**
     * 微信发券占比
     */

    WECHAT_OPEN_RATE("wechatOpenRate","wechat_open_rate"),
    WECHAT_OPEN_RATE_SHOW("wechatOpenRateShow","wechat_open_rate"),

    /**
     * IMEI发券占比
     */
    IMEI_OPEN_RATE("imeiOpenRate","imei_open_rate"),
    IMEI_OPEN_RATE_SHOW("imeiOpenRateShow","imei_open_rate"),
    /**
     * 老用户占比（当日uv中在前三天有访问记录的uv记为老用户）
     */
    OLD_RATE("oldRate","old_rate"),
    OLD_RATE_SHOW("oldRateShow","old_rate"),
    /**
     * 广告券点击率
     */
    CLICK_RATE("clickRate","click_rate"),
    CLICK_RATE_SHOW("clickRateShow","click_rate"),
    /**
     * 人均发券
     */
    AVG_COUPONS("avgCoupons","per_open_pv"),
    /**
     * 人均重复发券
     */
    REPEAT_COUPONS("repeatCoupons","rpt_open_pv"),

    /**
     * 点击量
     */
    CLICK_PV("clickPv","click_pv"),
    /**
     * 人均发券量
     */
    PER_OPEN_PV("perOpenPv","per_open_pv"),

    /**
     * 人均重复发券
     */
    RPT_OPEN_PV("rptOpenPv","rpt_open_pv"),
    /**
     * 券收入
     */
    INCOME("income","income"),
    INCOME_CHANGE("incomeChange","income_change"),
    /**
     * 开发者收益
     */
    DEVELOPER_INCOME("developerIncome","developer_income"),
    DEVELOPER_INCOME_CHANGE("developerIncomeChange","developer_income_change"),
    /**
     * 变现猫收益
     */
    BXM_INCOME("bxmIncome","bxm_income"),
    /**
     * 子链接收益（排序）
     */
    BUSINESS_INCOME("businessIncome","business_income"),
    BUSINESS_INCOME_CHANGE("businessIncomeChange","business_income_change"),
    /**
     * 发券ARPU
     */
    OPEN_PV_ARPU("openPvAurp","open_pv_arpu"),
    OPEN_PV_ARPU_CHANGE("openPvAurpChange","open_pv_arpu_change"),
    INCOME_AURP_CHANGE("incomeAurpChange","income_aurp_change"),
    /**
     * UVARPU
     */
    UV_ARPU("uvAurp","uv_arpu"),
    INCOME_AURP("incomeAurp","income_aurp"),
    UV_ARPU_CHANGE("uvAurpChange","uv_arpu_change"),
    /**
     * 开发者UVARPU
     */
    DEVELOPER_ARPU("developerAurp","developer_arpu"),
    DEVELOPER_ARPU_CHANGE("developerAurpChange","developer_arpu_change"),
    /**
     * 变现猫UVARPU
     */
    BXM_ARPU("bxmAurp","bxm_arpu"),
    BXM_ARPU_CHANGE("bxmAurpChange","bxm_arpu_change"),
    /**
     * 子链接 UVARPU 涨幅
     */
    BUSINESS_ARPU("businessAurp","business_arpu"),

    BUSINESS_ARPU_CHANGE("businessAurpChange","business_arpu_change"),

    
    /**
     * 子链接uvarpu
     */
    BUSINESS_UV_ARPU("bussinessUvArpu","business_uv_arpu"),
    
    
    /**
     * 子链接uvarpu
     */
    BUSINESS_UV_ARPU_CHANGE("bussinessUvArpuChange","business_uv_arpu_change"),

    /**
     * 开发者子链接 广告位曝光
     * */
    ICON_PV("iconPv","icon_pv"),

    /**
     * 开发者子链接 首页曝光数
     * */
    LANDING_PAGE_PV("laningPagePv","landing_page_pv"),
    /**
     * 开发者子链接按日 页面到达率
     * */

    MID_PAGE_RATE("midPageRate","mid_page_rate"),
    /**
     * 开发者子链接按日 页面展现率
     * */

    LANDING_PAGE_RATE("landingPageRate","landing_page_rate"),
    /**
     * 人均点击量=人均券点击
     */
    PER_CLICK_PV("perClickPv","per_click_pv"),
    /**
     *人均点击量环比昨日
     */
    PER_CLICK_PV_CHANGE("perClickPvChange","per_click_pv_change"),
    
    //新增开始
    INCOME_UVARPU("incomeUvarpu","income_uvarpu"),
    
    INCOME_ECPM("incomeEcpm","income_ecpm"),
    
    UVARPU("uvarpu","uvarpu"),
    
    ECPM("ecpm","ecpm"),
    
    ECPM_CHANGE("ecpmChange","ecpm_change"),

    TICKET_NUM("ticket_num","ticket_num"),
    
    HOURS("hours","hours");
    //新增结束
    
    private String code;

    private String name;

    AppFiledEnum(String code, String name){
        this.code = code;
        this.name = name;
    }

    /**
     * @return the code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }


    /**
     * 所有状态
     *
     * @return
     */
    public static Map<String, String> getAllState() {
        AppFiledEnum[] sts = AppFiledEnum.values();
        Map<String, String> maps = new HashMap<String, String>();
        for (AppFiledEnum tmp : sts) {
            maps.put(tmp.code, tmp.name);
        }
        return maps;
    }

    /**
     * 根据code得到name
     *
     * @param code
     * @return
     */
    public static String getName(String code) {
        try{
            for (AppFiledEnum state : AppFiledEnum.values()) {
                if (state.getCode().equals(code)) {
                    return state.getName();
                }
            }
        }catch (Exception e){
            return "";
        }
        return "not find enum";
    }
}
