/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with http://www.bianxianmao.com.
 */

package com.bxm.datapark.web.model.old.util;

import org.apache.commons.lang3.StringUtils;

import java.text.DecimalFormat;

/**
 * 处理字符串工具
 *
 * @author 阿导
 * @version v1.1.4_Report
 * @fileName com.bxm.datapark.model.mongo.util.VoUtil.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-28 20:24:00
 * @modifier 阿导
 * @updated 2018-02-28 20:24:00
 */
public class VoUtil {

    /**
     * 处理涨幅度
     *
     * @author 阿导
     * @time 2018/2/26
     * @CopyRight 万物皆导
     * @param change
     * @return java.lang.String
     */
    public static String percentage(String change){
        if(StringUtils.isEmpty(change)|| "-".equals(change)){
            return "-";
        }
        return change.replaceAll("%","")+"%";
    }

    /**
     * 计算arpu或ecpm
    * */
    public static Double getArpuOrEcpm(Double income , Integer number){
        if (number==null || number.intValue()==0 || income==null){
            return 0.0;
        }
        DecimalFormat df = new DecimalFormat("#.0000");
        String sArpu = df.format(income/(double)number);
        return Double.parseDouble(sArpu);
    }
    public static Double getArpuOrEcpm(String income , Integer number){
        if (number==null || number.intValue()==0 || income==null){
            return 0.0;
        }
        DecimalFormat df = new DecimalFormat("#.0000");
        Integer aIncome = Integer.parseInt(income);
        String sArpu = df.format((double)aIncome/number);
        return Double.parseDouble(sArpu);
    }

    /**
     * 保留两位小数
     *
     * @param d
     * @return
     */
    public static String formatDouble(Double d) {
        return formatDouble(d, "#.00");
    }
    public static String formatDouble(Double d, String fomat) {
        DecimalFormat df = new DecimalFormat(fomat);
        String rs = df.format(d);
        if (rs.indexOf("-") != Integer.valueOf(-1).intValue()) {
            return rs.indexOf(".") == Integer.valueOf(1).intValue() ? rs.replaceFirst("-", "-0") : rs;
        } else {
            return rs.indexOf(".") == Integer.valueOf(0).intValue() ? "-0" + rs : rs;
        }
    }
}
