package com.bxm.datapark.facade.adpopup.service;

import com.bxm.datapark.facade.adpopup.model.vo.AdPopupClickRateVo;
import com.bxm.datapark.facade.adpopup.model.vo.AdPopupReportVo;
import com.bxm.datapark.facade.adpopup.model.dao.AdpopupReportDao;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.bxm.datapark.facade.Page;
import com.bxm.util.dto.ResultModel;

import java.util.List;
import java.util.Map;

/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

/**
* 类说明：弹窗报表服务
* @author 作者： bcc
* @version 创建时间：2018年5月30日 下午4:21:43
*/
@FeignClient(name="datapark")
public interface AdPopupReportService {

	@RequestMapping(value = "/adpopup/adopupReport", method = RequestMethod.POST, consumes="application/json")
	public ResultModel<Page<AdPopupReportVo>> adopupReport(@RequestBody AdpopupReportDao dto);

	@RequestMapping(value = "/adpopup/popupClickPvUv", method = RequestMethod.POST, consumes="application/json")
	public ResultModel<Map<Long,AdPopupClickRateVo>> popupClickPvUv(@RequestBody AdpopupReportDao dto);

}
