package com.bxm.datapark.facade.position.model.dto;

import java.io.Serializable;

/**
* @Title:PositionClassCountDto.java
* @Package:com.bxm.datapark.facade.position.model.dto
* @Description: 广告位分类统计dto
* @date:2018年10月19日 下午6:06:58
* @author wangchao
 */
public class PositionClassCountDto implements Serializable {

    private static final long serialVersionUID = -8172582558520398856L;

    /**
     * 查询时间
     */
    private String datetime;

    /**
     * 广告位分类名
     */
    private String className;

    /**
     * 排序列
     */
    private String sortName;

    /**
     * 排序类型
     */
    private String sortType;
    /**
     * 页面号
     */
    private Integer pageNum = 1;

    /**
     * 页面大小
     */
    private Integer pageSize = 20;

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getSortName() {
        return sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

}
