package com.bxm.datapark.facade.position.model.dto;

import java.io.Serializable;
import java.util.List;

/**
* @Title:PositionHourCountDto.java
* @Package:com.bxm.datapark.facade.position.model.dto
* @Description: 广告位按小时统计dto
* @date:2018年10月19日 下午6:07:23
* @author wangchao
 */
public class PositionHourCountDto implements Serializable {

    private static final long serialVersionUID = 1083286233661054849L;

    /**
     * 查询时间
     */
    private String datetime;

    /**
     * app名称
     */
    private String appName;
    
    /**
     * appKey
     */
    private String appKey;
    
    /**
     * 子链接
     */
    private String business;

    /**
     * 广告位ID或者名称
     */
    private String keywords;
    
    /**
     * appKey集合
     */
    private List<String> appKeys;
    
    /**
     * 广告位ID的集合
     */
    private List<String> positionIds;
    /**
     * 排序列
     */
    private String sortName;
    
    /**
     * 排序类型
     */
    private String sortType;
    
    /**
     * 页面号
     */
    private Integer pageNum = 1;
    
    /**
     * 页面大小
     */
    private Integer pageSize = 20;
    
    /**
     * 开始查询小时
     */
    private String beginHour;
    
    /**
     * 结束查询小时
     */
    private String endHour;
    

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }
    
    public String getSortName() {
        return sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public List<String> getAppKeys() {
        return appKeys;
    }

    public void setAppKeys(List<String> appKeys) {
        this.appKeys = appKeys;
    }

    public List<String> getPositionIds() {
        return positionIds;
    }

    public void setPositionIds(List<String> positionIds) {
        this.positionIds = positionIds;
    }

    public String getBeginHour() {
        return beginHour;
    }

    public void setBeginHour(String beginHour) {
        this.beginHour = beginHour;
    }

    public String getEndHour() {
        return endHour;
    }

    public void setEndHour(String endHour) {
        this.endHour = endHour;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getBusiness() {
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }
    
}
