package com.bxm.datapark.facade.ticket.service;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.dto.AnalysisParamsDTO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.*;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/9 10:55
 * 修 改 人：
 * 日 期：
 * 描 述：广告券数据统计 接口
 * 版 本 号： v1
 */
@FeignClient(name = "datapark")
public interface TicketAnalysisService {

    /**
     * Description: 趋势维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/trend", method = RequestMethod.POST)
    ResultModel<Page<AnalysisTrendVO>> trend(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 媒体维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/media", method = RequestMethod.POST)
    ResultModel<Page<AnalysisMediaVO>> media(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 区域维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/region", method = RequestMethod.POST)
    ResultModel<Page<AnalysisRegionVO>> region(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 广告类型维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/tagType", method = RequestMethod.POST)
    ResultModel<Page<AnalysisTagTypeVO>> tagType(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 操作系统维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/appOS", method = RequestMethod.POST)
    ResultModel<Page<AnalysisAppOSVO>> appOS(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 支付类型维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/paymentType", method = RequestMethod.POST)
    ResultModel<Page<AnalysisPaymentTypeVO>> paymentType(AnalysisParamsDTO paramsDTO);


    //
    //  下面是图表数据的接口
    //

    /**
     * Description: 趋势维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/chart/trend", method = RequestMethod.POST)
    ResultModel<Map<String, Object>> trendChart(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 媒体维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/chart/media", method = RequestMethod.POST)
    ResultModel<Map<String, Object>> mediaChart(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 区域维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/chart/region", method = RequestMethod.POST)
    ResultModel<Map<String, Object>> regionChart(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 广告类型维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/chart/tagType", method = RequestMethod.POST)
    ResultModel<Map<String, Object>> tagTypeChart(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 操作系统维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/chart/appOS", method = RequestMethod.POST)
    ResultModel<Map<String, Object>> appOSChart(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 支付类型维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/chart/paymentType", method = RequestMethod.POST)
    ResultModel<Map<String, Object>> paymentTypeChart(AnalysisParamsDTO paramsDTO);

    /**
     *
     * 功能描述: 广告ka分析查询
     * @fileName:
     * @param: [startTime, endTime, ticketTypes, sortType, sortName]
     * @return: com.bxm.util.dto.ResultModel<java.util.Map<java.lang.String,java.lang.Object>>
     * @auther: sunzs
     * @date: 2019/3/12 20:51
     */
    @RequestMapping(value = "/analysis/ticket/findTicketKA")
    public ResultModel<Map<String,Object>> findTicketKA(@RequestParam(value = "startTime")String startTime,
                                                        @RequestParam(value = "endTime")String endTime,
                                                        @RequestParam(value = "ticketTypes")String ticketTypes,
                                                        @RequestParam(value = "sortType",defaultValue = "DESC")String sortType,
                                                        @RequestParam(value = "sortName")String sortName);

    /**
     *
     * 功能描述: 广告ka分析查询导出
     * @fileName:
     * @param: [startTime, endTime, ticketTypes, sortType, sortName]
     * @return: com.bxm.util.dto.ResultModel<java.util.Map<java.lang.String,java.lang.Object>>
     * @auther: sunzs
     * @date: 2019/3/12 20:51
     */
    @RequestMapping(value = "/analysis/ticket/ticketKAExport")
    public ResultModel<List<TicketKAExportVo>> ticketKAExport(@RequestParam(value = "startTime")String startTime,
                                                            @RequestParam(value = "endTime")String endTime,
                                                            @RequestParam(value = "ticketTypes")String ticketTypes);

    /**
     *
     * 功能描述: 广告主分析
     * @fileName:
     * @param: [startTime, endTime, advertiserIds]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2019/3/7 14:33
     */
    @RequestMapping(value = "/analysis/findAdvertiserData")
    public ResultModel<Page<AdvertiserAnalysis>> findAdvertiserData(@RequestParam(value = "startTime")String startTime,
                                          @RequestParam(value = "endTime")String endTime,
                                          @RequestParam(value = "advertiserIds")String advertiserIds,
                                          @RequestParam(value = "sortType")String sortType,
                                          @RequestParam(value = "sortName")String sortName,
                                          @RequestParam(value = "pageNum")Integer pageNum,
                                          @RequestParam(value = "pageSize")Integer pageSize);

    /**
     *
     * 功能描述: 广告主分析Top10消耗趋势
     * @fileName:
     * @param: [startTime, endTime]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2019/3/12 20:54
     */
    @RequestMapping(value = "/analysis/findAdConsumeChar")
    public  ResultModel findAdConsumeChar(@RequestParam(value = "startTime")String startTime,
                                          @RequestParam(value = "endTime")String endTime,
                                          @RequestParam(value = "adertosers")String adertosers);

    /**
     *
     * 功能描述:
     * @fileName:广告主消耗和发券arpu条形图
     * @param: [startTime, endTime]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2019/3/12 20:56
     */
    @RequestMapping(value = "/analysis/findAdConsumeAndOpenPvArpuChar")
    public  ResultModel findAdConsumeAndOpenPvArpuChar(@RequestParam(value = "startTime")String startTime,
                                                       @RequestParam(value = "endTime")String endTime,
                                                       @RequestParam(value = "advertisers")String advertisers);


    /**
     *
     * 功能描述:
     * @fileName:广告主消耗和发券arpu条形图
     * @param: [startTime, endTime]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2019/3/12 20:56
     */
    @RequestMapping(value = "/analysis/reFindAdConsumeAndOpenPvArpuChar")
    public  ResultModel reFindAdConsumeAndOpenPvArpuChar(@RequestParam(value = "startTime")String startTime,
                                                       @RequestParam(value = "endTime")String endTime,
                                                       @RequestParam(value = "advertisersConsume")String advertisersConsume,
                                                       @RequestParam(value = "advertisersArpu")String advertisersArpu);
}

