package com.bxm.datapark.web;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.web.model.PositionData;
import com.bxm.datapark.web.model.SearchDataCommon;
import com.bxm.datapark.web.model.SearchPanguDataDTO;
import com.bxm.warcar.utils.response.ResultModel;

/**
 * <h3>OCPC</h3>
 *
 * @author tangxiao
 * @since V1.0.0, 2019/12/12 14:01
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadePositionDataService {

    @RequestMapping("/data/position")
    ResultModel<List<PositionData>> getPositionData(@RequestBody SearchDataCommon search);

    @RequestMapping("/data/media")
    ResultModel<List<PositionData>> getMediaData(@RequestBody SearchDataCommon search);

    /**
     * 获取盘古广告位收益
     * @param search
     * @return
     */
    @RequestMapping("/data/panguPosition")
    ResultModel<List<PositionData>> getPanguPositionData(@RequestBody SearchPanguDataDTO search);
}
