package com.bxm.datapark.web;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.web.model.RtbPositionCvrControlDTO;
import com.bxm.datapark.web.model.RtbPositionGroupHourly;
import com.bxm.datapark.web.model.SspPositionFinanceDaily;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * <h3>rtb相关</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/11/11 14:01
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadePositionRtbDataService {

    /**
     * 广告位收益
     * @param search
     * @return
     */
    @RequestMapping("/data/rtb/getRtbAdGroupData")
    ResultModel<List<RtbPositionGroupHourly>> getRtbAdGroupData(@RequestBody RtbPositionCvrControlDTO search);
}
