package com.bxm.datapark.web;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import com.bxm.datapark.DataParkConstants;
import com.bxm.datapark.web.model.SspActivity;
import com.bxm.datapark.web.model.SspActivityData;
import com.bxm.datapark.web.model.SspActivityDataDTO;
import com.bxm.warcar.utils.response.ResultModel;

/**
 * <p>
 * SSP场景DSP活动数据
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-08-13
 */
@FeignClient(name = DataParkConstants.WEB_SERVICE)
public interface FacadeSspActivityDataServive {

    /**
     * 查询可用的活动列表数据
     * @param search
     * @return
     */
    @RequestMapping("/data/ssp/activity/list")
    ResultModel<List<SspActivity>> getActivity(@RequestBody SspActivity search);

    /**
     * 根据广告位查询活动相关的统计数据
     * @param search
     * @return
     */
    @RequestMapping("/data/ssp/activity/data")
    ResultModel<List<SspActivityData>> getActivityData(@RequestBody SspActivityDataDTO search);
}
