package com.bxm.datapark.web.model;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;

/**
 * <h3>数据实体公共类</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2019/11/11 14:18
 */
public class DataCommon implements Serializable {

    private static final long serialVersionUID = 8603702740176512921L;

    /**
     * 日期
     */
    private String datetime;

    /**
     * 券id
     */
    private Long ticketId;

    /**
     * appkey
     */

    private String appkey;

    /**
     * 子渠道标志
     */

    private String business;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 入口pv
     */
    private Integer iconPv;

    /**
     * 入口点击量
     */
    private Integer iconClickPv;

    /**
     * 中间页uv
     */
    private Integer midPageUv;

    /**
     * 中间页pv
     */
    private Integer midPagePv;

    /**
     * 活动首页pv
     */
    private Integer indexPv;

    /**
     * 活动首页uv
     */
    private Integer indexUv;

    /**
     * 活动参与uv
     */
    private Integer joinUv;

    /**
     * 发券请求
     */
    private Integer sendPv;

    /**
     * 曝光量（发券量）
     */
    private Integer openPv;

    /**
     * 点击量
     */
    private Integer clickPv;

    /**
     * 有效点击量
     */
    private Integer validClick;

    /**
     * 券收入
     */
    private Double income;

    /**
     * 券消耗
     */
    private Double consume;

    /**
     * 变现猫收益
     */
    private Double bxmIncome;

    /**
     * UVARUP
     */
    private Double uvArpu;

    /**
     * 发券aurp
     */
    private Double sendArpu;

    /**
     * 点击aurp
     */
    private Double clickArpu;

    /**
     * 媒体消耗
     */
    private Double mediaConsume;

    /**
     * 广告位消耗
     */
    private Double positionConsume;

    /**
     * 作弊有效点击
     */
    private Integer cheatValidClick;

    /**
     * 有效点击不去重
     */
    private Integer validClickPvAll;

    /**
     * 活动pv  去重
     */
    private Integer landingPagePv;

    public Integer getLandingPagePv() {
        return landingPagePv;
    }

    public void setLandingPagePv(Integer landingPagePv) {
        this.landingPagePv = landingPagePv;
    }

    public Integer getValidClickPvAll() {
        return validClickPvAll;
    }

    public void setValidClickPvAll(Integer validClickPvAll) {
        this.validClickPvAll = validClickPvAll;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getBusiness() {
        if(StringUtils.isNotBlank(business)){
            return business.replace("money","ad");
        }
        return business;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public Integer getIconPv() {
        return iconPv;
    }

    public void setIconPv(Integer iconPv) {
        this.iconPv = iconPv;
    }

    public Integer getIconClickPv() {
        return iconClickPv;
    }

    public void setIconClickPv(Integer iconClickPv) {
        this.iconClickPv = iconClickPv;
    }

    public Integer getMidPageUv() {
        return midPageUv;
    }

    public void setMidPageUv(Integer midPageUv) {
        this.midPageUv = midPageUv;
    }

    public Integer getMidPagePv() {
        return midPagePv;
    }

    public void setMidPagePv(Integer midPagePv) {
        this.midPagePv = midPagePv;
    }

    public Integer getIndexPv() {
        return indexPv;
    }

    public void setIndexPv(Integer indexPv) {
        this.indexPv = indexPv;
    }

    public Integer getIndexUv() {
        return indexUv;
    }

    public void setIndexUv(Integer indexUv) {
        this.indexUv = indexUv;
    }

    public Integer getJoinUv() {
        return joinUv;
    }

    public void setJoinUv(Integer joinUv) {
        this.joinUv = joinUv;
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public Integer getValidClick() {
        return validClick;
    }

    public void setValidClick(Integer validClick) {
        this.validClick = validClick;
    }

    public Double getIncome() {
        return income;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public Double getConsume() {
        return consume;
    }

    public void setConsume(Double consume) {
        this.consume = consume;
    }

    public Double getBxmIncome() {
        return bxmIncome;
    }

    public void setBxmIncome(Double bxmIncome) {
        this.bxmIncome = bxmIncome;
    }

    public Double getUvArpu() {
        return uvArpu;
    }

    public void setUvArpu(Double uvArpu) {
        this.uvArpu = uvArpu;
    }

    public Double getSendArpu() {
        return sendArpu;
    }

    public void setSendArpu(Double sendArpu) {
        this.sendArpu = sendArpu;
    }

    public Double getClickArpu() {
        return clickArpu;
    }

    public void setClickArpu(Double clickArpu) {
        this.clickArpu = clickArpu;
    }

    public Double getMediaConsume() {
        return mediaConsume;
    }

    public void setMediaConsume(Double mediaConsume) {
        this.mediaConsume = mediaConsume;
    }

    public Double getPositionConsume() {
        return positionConsume;
    }

    public void setPositionConsume(Double positionConsume) {
        this.positionConsume = positionConsume;
    }

    public Integer getCheatValidClick() {
        return cheatValidClick;
    }

    public void setCheatValidClick(Integer cheatValidClick) {
        this.cheatValidClick = cheatValidClick;
    }
}
