package com.bxm.datapark.web.model;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 点石成金广告位财务报表
 * </p>
 *
 * @author hcmony
 * @since 2020-01-11
 */

public class SspPositionFinanceDaily implements Serializable {

    private String datetime;

    /**
     * 广告位id标识
     */
    private String positionId;

    /**
     * 应用ID
     */
    private String appId;

    private Long dspId;

    /**
     * 开发者id
     */
    private Long developerId;

    /**
     * 媒体端请求到变现猫的请求量
     */
    private Integer requestPv;

    /**
     * 广告真实在广告位上曝光的数量
     */
    private Integer exposurePv;

    /**
     * 广告真实在广告位上点击的数量
     */
    private Integer clickPv;

    /**
     * 广告端竞价收入，单位：元
     * API-实时竞价时：上报给ADX的价格累加，单位：元
     */
    private BigDecimal bidIncome;

    /**
     * API-实时竞价时：上报给DSP的价格累加，单位：元
     */
    private BigDecimal dspIncome;

    /**
     * 媒体端请求到变现猫的请求uv
     */
    private Integer requestUv;

    /**
     * 活动首页曝光uv
     */
    private Integer indexUv;

    /**
     * 活动曝光1日留存uv
     */
    private Integer retain1IndexUv;

    /**
     * 广告端广告位Id
     */
    private String pointPositionId;

    public String getPointPositionId() {
        return pointPositionId;
    }

    public void setPointPositionId(String pointPositionId) {
        this.pointPositionId = pointPositionId;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Long getDspId() {
        return dspId;
    }

    public void setDspId(Long dspId) {
        this.dspId = dspId;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public Integer getRequestPv() {
        return requestPv;
    }

    public void setRequestPv(Integer requestPv) {
        this.requestPv = requestPv;
    }

    public Integer getExposurePv() {
        return exposurePv;
    }

    public void setExposurePv(Integer exposurePv) {
        this.exposurePv = exposurePv;
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public BigDecimal getBidIncome() {
        return bidIncome;
    }

    public void setBidIncome(BigDecimal bidIncome) {
        this.bidIncome = bidIncome;
    }

    public BigDecimal getDspIncome() {
        return dspIncome;
    }

    public void setDspIncome(BigDecimal dspIncome) {
        this.dspIncome = dspIncome;
    }

    public Integer getRequestUv() {
        return requestUv;
    }

    public void setRequestUv(Integer requestUv) {
        this.requestUv = requestUv;
    }

    public Integer getIndexUv() {
        return indexUv;
    }

    public void setIndexUv(Integer indexUv) {
        this.indexUv = indexUv;
    }

    public Integer getRetain1IndexUv() {
        return retain1IndexUv;
    }

    public void setRetain1IndexUv(Integer retain1IndexUv) {
        this.retain1IndexUv = retain1IndexUv;
    }
}
