package com.bxm.datapark.web.model.old.entity.analysis;

import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/14 17:23
 * 修 改 人：
 * 日 期：
 * 描 述：
 * 版 本 号： v1
 */
@Data
@Document
public class TicketAnalysisPaymentType implements Serializable {
    private static final long serialVersionUID = -5258331678845300792L;

    /**
     * 媒体ID, 广告位ID, 广告ID
     */
    @Field("app_key")
    private String appKey;
    @Field("position_id")
    private String positionId;
    @Field("ticket_id")
    private String ticketId;

    /**
     * 支付场景，1：微信，2：支付宝，3：其他
     */
    @Field("ua")
    private Integer ua;

    /**
     * 发券数, 点击数
     */
    @Field("open_pv")
    private Integer openPV;
    @Field("click_pv")
    private Integer clickPV;

    /**
     * 效果监测数, 广告总收入
     */
    @Field("page_exposure_pv")
    private Integer pageExposurePV;
    @Field("income")
    private Double income;

    public TicketAnalysisPaymentType() {
        this.openPV = 0;
        this.clickPV = 0;
        this.pageExposurePV = 0;
        this.income = 0.0;
    }

}
