/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with http://www.bianxianmao.com.
 */

package com.bxm.datapark.web.model.old.vo.newad;

import com.bxm.util.dto.VoUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 广告券日报
 *
 * @author 董朱旭
 * @version BUILD1001
 * @fileName com.bxm.datapark.dal.mongo.vo.TicketCountCommon.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司
 * @created 2018-01-06 16:36:00
 * @modifier 董朱旭
 * @updated 2018-01-06 16:36:00
 * @modifier kk.xie
 * @updated 2018-7-8 17:20:40
 * @description 开发者日报-子链接-广告券 报表中添加字段
 */
public class TicketCountCommon implements Serializable {
    @Override
    public String toString() {
        return "TicketCountCommon{" +
                "consume=" + consume +
                ", exposureRate=" + exposureRate +
                ", exposurePv=" + exposurePv +
                '}';
    }

    private static final long serialVersionUID = -6710758344330604280L;

    /**
     * 编号
     */
    private String number;

    /**
     * 日期
     */

    private String datetime;


    /**
     * 券id
     */

    @Field("certificate_id")
    private Long certificateid;

    /**
     * appkey
     */

    @Field("app_key")
    private String appkey;

    /**
     * 子渠道标志
     */

    @Field("business")
    private String business;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 发券请求
     */

    @Field("send_pv")
    private Integer sendPv;
    /**
     * 发券请求涨幅
     */

    @Field("send_pv_change")
    private String sendPvChange;
    /**
     * 点击量
     */

    @Field("click_pv")
    private Integer clickPv;
    /**
     * 点击量涨幅
     */

    @Field("click_pv_change")
    private String clickPvChange;

    /**
     * 曝光量（发券量）
     */

    @Field("open_pv")
    private Integer openPv;

    /**
     * 曝光量（发券量）涨幅
     */
    @Field("open_pv_change")
    private String openPvChange;

    /**
     * 有效点击量
     */
    @Field("valid_click_pv")
    private Integer validClick;

    /**
     * 有效点击量涨幅
     */
    @Field("valid_click_change")
    private String validClickChange;


    /**
     * 有效点击率
     */
    @Field("valid_rate")
    private Double validClickRate;


    /**
     * 有效点击率涨幅
     */
    @Field("valid_rate_change")
    private String validClickRateChange;

    /**
     * 转化率
     */
    @Field("click_rate")
    private Double conversion;

    /**
     * 转化率涨幅
     */
    @Field("click_rate_change")
    private String conversionChange;

    /**
     * 券收入
     */
    @Field("income")
    private Double income;

    /**
     * 券收入涨幅
     */
    @Field("income_change")
    private String incomeChange;


    /**
     * 发券aurp
     */
    @Field("open_pv_arpu")
    private Double openPvAurp;
    /**
     * 发券aurp涨幅
     */
    @Field("open_pv_arpu_change")
    private String openPvAurpChange;
    /**
     * 点击aurp
     */
    @Field("click_arpu")
    private Double clickAurp;
    /**
     * 点击aurp涨幅
     */
    @Field("click_arpu_change")
    private String clickAurpChange;

    /**
     * 有效点击率占比
     */
    @Field("quality_factor")
    private Double qualityFactor;

    /**
     * 有效点击率占比涨幅
     */
    @Field("quality_factor_change")
    private String qualityFactorChange;


    @Field("hours")
    private Integer hours;

    /**
     * 是否是首张弹券
     */

    @Field("scene")
    private Integer scene;

    /**
     * 发券占比
     */
    private Double openPvRate;

    /**
     * 发券占比涨幅
     */
    private String openPvRateChange;

    /**
     * 券消耗
     */

    private Double consume;

    /**
     * 券消耗涨幅
     */
    @Field("consume_change")
    private String consumeChange;

    /**
     * 曝光成功率
     */
    @Field("exposure_rate")
    private Double exposureRate;

    /**
     * 曝光成功率涨幅
     */
    @Field("exposure_rate_change")
    private String exposureRateChange;

    /**
     * 成功曝光数
     */
    @Field("exposure_pv")
    private Integer exposurePv;

    /**
     * 礼券日平均权重
     * add by kk,xie times:2018-7-8 11:50:03
     */
    @Field("average_weight")
    private BigDecimal averageWeightByDay;

    /**
     * 礼券发券机会
     * add by kk,xie times:2018-7-8 11:50:03
     */
    @Field("opening_chance")
    private String sendTicketProbability;

    /**
     * 礼券发券的设备限制
     * add by kk,xie times:2018-7-8 11:50:03
     */
    @Field("device_limit")
    private String equipmentConstraints;

    /**
     * 礼券发券的环境限制
     * add by kk,xie times:2018-7-8 11:50:03
     */
    @Field("environment_limit")
    private String environmentConstraints;

    /**
     * 礼券发券的地域限制
     * add by kk,xie times:2018-7-8 11:50:03
     */
    @Field("region_limit")
    private String regionConstraints;

    /**
     * 礼券的总发券机会
     * add by kk,xie times:2018-7-8 11:50:03
     */
    @Field("total_opening_chance")
    private String totalSendTicketProbability;

    /**
     * 发券时间
     * add by kk,xie times:2018-7-4 11:50:03
     */
    @Field("opening_time")
    private String sendTicketTime;

    /**
     * 作弊有效点击
     */
    private Integer cheatValidClick;

    /**
     * 有效点击不去重
     */
    private Integer validClickPvAll;


    public Integer getValidClickPvAll() {
        return validClickPvAll;
    }

    public void setValidClickPvAll(Integer validClickPvAll) {
        this.validClickPvAll = validClickPvAll;
    }

    public String getSendTicketTime() {
        return sendTicketTime;
    }

    public void setSendTicketTime(String sendTicketTime) {
        this.sendTicketTime = sendTicketTime;
    }

    public BigDecimal getAverageWeightByDay() {
        return averageWeightByDay;
    }

    public void setAverageWeightByDay(BigDecimal averageWeightByDay) {
        this.averageWeightByDay = averageWeightByDay;
    }

    public String getSendTicketProbability() {
        return sendTicketProbability;
    }

    public void setSendTicketProbability(String sendTicketProbability) {
        this.sendTicketProbability = sendTicketProbability;
    }

    public String getEquipmentConstraints() {
        return equipmentConstraints;
    }

    public void setEquipmentConstraints(String equipmentConstraints) {
        this.equipmentConstraints = equipmentConstraints;
    }

    public String getEnvironmentConstraints() {
        return environmentConstraints;
    }

    public void setEnvironmentConstraints(String environmentConstraints) {
        this.environmentConstraints = environmentConstraints;
    }

    public String getRegionConstraints() {
        return regionConstraints;
    }

    public void setRegionConstraints(String regionConstraints) {
        this.regionConstraints = regionConstraints;
    }

    public String getTotalSendTicketProbability() {
        return totalSendTicketProbability;
    }

    public void setTotalSendTicketProbability(String totalSendTicketProbability) {
        this.totalSendTicketProbability = totalSendTicketProbability;
    }

    public Double getConsume() {
        return consume != null ? consume : 0;
    }

    public void setConsume(Double consume) {
        this.consume = consume;
    }

    public String getConsumeChange() {
        return VoUtil.percentage(consumeChange);
    }

    public void setConsumeChange(String consumeChange) {
        this.consumeChange = consumeChange;
    }

    public Double getExposureRate() {
        return exposureRate;
    }

    public void setExposureRate(Double exposureRate) {
        this.exposureRate = exposureRate;
    }

    public String getExposureRateChange() {
        return VoUtil.percentage(exposureRateChange);
    }

    public void setExposureRateChange(String exposureRateChange) {
        this.exposureRateChange = exposureRateChange;
    }


    public Integer getExposurePv() {
        return exposurePv;
    }

    public void setExposurePv(Integer exposurePv) {
        this.exposurePv = exposurePv;
    }

    public Integer getHours() {
        return hours;
    }

    public void setHours(Integer hours) {
        this.hours = hours;
    }

    public Double getIncome() {
        return income == null ? 0D : income;
    }

    public void setIncome(Double income) {
        this.income = income;
    }

    public String getDatetime() {
        return datetime;
    }

    public Long getCertificateid() {
        return certificateid;
    }

    public String getAppkey() {
        return appkey;
    }

    public String getBusiness() {
        return business;
    }

    public Integer getSendPv() {
        return sendPv;
    }

    public String getSendPvChange() {
        return VoUtil.percentage(sendPvChange);
    }

    public Integer getClickPv() {
        return clickPv;
    }

    public String getClickPvChange() {
        return VoUtil.percentage(clickPvChange);
    }

    public Integer getOpenPv() {
        return openPv;
    }

    public String getOpenPvChange() {
        return VoUtil.percentage(openPvChange);
    }

    public Integer getValidClick() {
        return validClick;
    }

    public String getValidClickChange() {
        return VoUtil.percentage(validClickChange);
    }

    public Double getValidClickRate() {
        return validClickRate;
    }

    public String getValidClickRateChange() {
        return VoUtil.percentage(validClickRateChange);
    }

    public Double getConversion() {
        return conversion;
    }

    public String getConversionChange() {
        return VoUtil.percentage(conversionChange);
    }

    public String getIncomeChange() {
        return VoUtil.percentage(incomeChange);
    }

    public Double getOpenPvAurp() {
        return openPvAurp;
    }

    public String getOpenPvAurpChange() {
        return VoUtil.percentage(openPvAurpChange);
    }

    public Double getClickAurp() {
        return clickAurp;
    }

    public String getClickAurpChange() {
        return VoUtil.percentage(clickAurpChange);
    }

    public Double getQualityFactor() {
        return qualityFactor;
    }

    public String getQualityFactorChange() {
        return VoUtil.percentage(qualityFactorChange);
    }

    public Double getOpenPvRate() {
        return openPvRate;
    }

    public String getOpenPvRateChange() {
        return VoUtil.percentage(openPvRateChange);
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public void setCertificateid(Long certificateid) {
        this.certificateid = certificateid;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public void setBusiness(String business) {
        this.business = business;
    }

    public void setSendPv(Integer sendPv) {
        this.sendPv = sendPv;
    }

    public void setSendPvChange(String sendPvChange) {
        this.sendPvChange = sendPvChange;
    }

    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    public void setClickPvChange(String clickPvChange) {
        this.clickPvChange = clickPvChange;
    }

    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    public void setOpenPvChange(String openPvChange) {
        this.openPvChange = openPvChange;
    }

    public void setValidClick(Integer validClick) {
        this.validClick = validClick;
    }

    public void setValidClickChange(String validClickChange) {
        this.validClickChange = validClickChange;
    }

    public void setValidClickRate(Double validClickRate) {
        this.validClickRate = validClickRate;
    }

    public void setValidClickRateChange(String validClickRateChange) {
        this.validClickRateChange = validClickRateChange;
    }

    public void setConversion(Double conversion) {
        this.conversion = conversion;
    }

    public void setConversionChange(String conversionChange) {
        this.conversionChange = conversionChange;
    }

    public void setIncomeChange(String incomeChange) {
        this.incomeChange = incomeChange;
    }

    public void setOpenPvAurp(Double openPvAurp) {
        this.openPvAurp = openPvAurp;
    }

    public void setOpenPvAurpChange(String openPvAurpChange) {
        this.openPvAurpChange = openPvAurpChange;
    }

    public void setClickAurp(Double clickAurp) {
        this.clickAurp = clickAurp;
    }

    public void setClickAurpChange(String clickAurpChange) {
        this.clickAurpChange = clickAurpChange;
    }

    public void setQualityFactor(Double qualityFactor) {
        this.qualityFactor = qualityFactor;
    }

    public void setQualityFactorChange(String qualityFactorChange) {
        this.qualityFactorChange = qualityFactorChange;
    }

    public void setOpenPvRate(Double openPvRate) {
        this.openPvRate = openPvRate;
    }

    public void setOpenPvRateChange(String openPvRateChange) {
        this.openPvRateChange = openPvRateChange;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public TicketCountCommon() {
    }

    public String getPositionId() {
        String positionIdTmp = "";
        if (StringUtils.isNotBlank(business)) {
            positionIdTmp = this.appkey + "-" + this.business.replace("ad-", "");
        }
        return positionId = positionIdTmp;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public Integer getCheatValidClick() {
        return cheatValidClick;
    }

    public void setCheatValidClick(Integer cheatValidClick) {
        this.cheatValidClick = cheatValidClick;
    }
}
