package com.bxm.doris.facade.model;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Auth lijingyu
 * 广告位券参竟数据
 */
@Data
public class TicketGinsengHerbResponse implements Serializable {

    private static final long serialVersionUID = 81435425486643906L;
    /**
     * 券ID
     */
    private Long ticketId;

    private String ticketName;

    /**
     * 是否加速探索 0：否1是
     */
    private Integer exploreBid;

    /**
     * 发券数
     */
    private Integer hairPv;

    /**
     * 参竟数
     */
    private Integer bidPv;

    /**
     * 曝光
     */
    private Integer openPv;

    /**
     * 收入
     */
    private BigDecimal income;

    /**
     * 券点击
     */
    private Integer clickPv;

    /**
     * 有效点击
     */
    private Integer validClickPv;

    /**
     * 竞胜率
     */
    private BigDecimal winRate;
    /**
     * 直投竞胜率
     */
    private BigDecimal directWinRate;

    /**
     * 收入发券arpu
     */
    private BigDecimal incomeArpu;
    /**
     * 直投点击均价
     */
    private BigDecimal clickAvgPrice;

    /**
     * cvr*ctr
     */
    private BigDecimal ctrCvr;

    /**
     * 曝光最高的省份
     */
    private String province;

    /**
     * 曝光最高的城市
     */
    private String city;

    /**
     * 操作系统
     */
    private String appOs;

    /**
     * 支付环境
     */
    private String payEnv;

    /**
     * 运营商
     */
    private String ispDomain;

    /**
     * 时段
     */
    private String thehour;

    /**
     * 位次
     */
    private Integer sequence;
}
