package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.monitor.FacadeDmAdAlarmDataMinutely;
import com.bxm.doris.facade.model.monitor.FacadeRtbValidateCost;
import feign.Param;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author daill
 * @date 2023/12/13
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface TicketPositionDailyFacadeService {

    /**
     * 提供广告位和卷
     * @param ticketId
     * @param positionId
     * @param today
     * @return
     */
    @RequestMapping(value = "/getIncomeForParams")
    int  getIncomeForParams(@RequestParam("ticketId") Long ticketId,
                         @RequestParam("positionId") String positionId,
                         @RequestParam("dateTime") String dateTime);


}
