package com.bxm.doris.facade.enums;


import org.springframework.util.StringUtils;

/**
 * @author 拉拉
 * @version v1.0.0
 * @created 2023-8-09 13:49:00
 */
public enum DimensionNameEnum {

    PROVIDER("province", "省"),
    CITY("city", "市"),
    UA("pay_env", "流量环境 微信 支付宝 其他"),
    OSS("app_os", "流量操作平台  android ios 其他"),

    ISP("isp_domain", "流量运营商"),


    //下面是 运营后台与报表对应的值
    OSS_ANDROID("1",""),
    OSS_IOS("2",""),
    OSS_OTHER("4",""),

    //移动
    ISP_MOBILE("10025",""),
    //电信
    ISP_TELECOM("10017",""),
    //联通
    ISP_CHINA("10026",""),
    //其他
    ISP_OTHER("000000",""),

    UA_ALIPAY("1",""),
    UA_OTHER("2",""),
    UA_WECHAT("5","");

    private String name;

    private String desc;


    DimensionNameEnum(String name, String desc) {
        this.desc = desc;
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public String getName() {
        return name;
    }

    public static DimensionNameEnum findDescByName(String name) {
        for (DimensionNameEnum r : values()) {
            if (StringUtils.endsWithIgnoreCase(name, r.name)) {
                return r;
            }
        }
        return null;
    }

}
