package com.bxm.doris.facade.model;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 广告位填充数据
 * @author tangxiao
 * @date 2023/9/18
 * @since 1.0
 */
@Data
public class PositionPaddingResponse {
    /**
     * 维度名称（地域、操作平台、操作环境、运营商）
     */
    private String dimension;
    /**
     * 当日备用券曝光
     */
    private Integer todayStandbyOpenPv;
    /**
     * 当前/上个时段备用券曝光
     */
    private Integer hourStandbyOpenPv;
    /**
     * 当前/上个时段券收入
     */
    private BigDecimal hourIncome;
    /**
     * 当前/上个时段发券arpu
     */
    private BigDecimal hourArpu;
    /**
     * 当前/上个时段点击均价
     */
    private BigDecimal hourClickAverage;
}
