package com.bxm.doris.facade.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @author jingyu.li
 * @date 2023-08-17
 */
@Data
public class TicketDimensionResponse {
    private static final long serialVersionUID = 81435425486643906L;
    /**
     * 券ID
     */
    private Long ticketId;

    /**
     * 参竟数
     */
    private Integer bidPv;

    /**
     * 收入发券arpu
     */
    private BigDecimal incomeArpu;

    /**
     * 点击均价
     */
    private BigDecimal clickAvgPrice;

    /**
     * 发券时段内覆盖小时数
     */
    private Integer hours;

    /**
     * top1参竟、arpu
     */
    private Integer hour;
    private DimensionData hourDimension;

    /**
     * 第一位次参竟、arpu
     */
    private DimensionData sequenceDimension;

    /**
     * 曝光最高的省份
     */
    private String province;
    private DimensionData provinceDimension;

    /**
     * 曝光最高的城市
     */
    private String city;
    private DimensionData cityDimension;

    /**
     * 操作系统
     */
    private String appOs;
    private DimensionData appOsDimension;

    /**
     * 支付环境
     */
    private String payEnv;
    private DimensionData payEnvDimension;

    /**
     * 运营商
     */
    private String ispDomain;
    private DimensionData ispDomainDimension;

    /**
     * 分组ID 日期：31 省份：47 城市：55 操作系统：59 支付环境：61 运营商：62
     * 如果添加分组，id会变
     */
    private Integer id;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class DimensionData{
        /**
         * 参竟数
         */
        private Integer bidPv;

        /**
         * 收入发券arpu
         */
        private BigDecimal incomeArpu;

        /**
         * 点击均价
         */
        private BigDecimal clickAvgPrice;
    }

    /**
     * 维度
     */
    private String dimension;
}
