package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.ProxyAdDataRequest;
import com.bxm.doris.facade.model.ProxyDataResponse;
import com.bxm.doris.facade.model.datapark.PositionData;
import com.bxm.doris.facade.model.datapark.SearchDataCommon;
import com.bxm.warcar.utils.response.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * @author zhangdong
 * @date 2023/12/12
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface PositionFacadeService {



    /**
     * 查询时间内产生曝光的广告位
     * @param beginDate 开始时间
     * @param endDate 结束时间
     * @return 广告位id
     */
    @GetMapping("/position/findHasExposeDataPositionId")
    List<String> findHasExposeDataPositionId(@RequestParam("beginDate") String beginDate, @RequestParam("endDate") String endDate);


    /**
     *
     * @param dateStr
     * @param    type=1 uv>=100  type=2 uv<100  0 uv>0
     * @return
     */
    @RequestMapping({"/data/adsmedia/getEffectiveUVListByType"})
    Set<String> getEffectiveUVListByType(@RequestParam("dateStr") String dateStr, @RequestParam(value = "type",defaultValue = "1") String type);


    @RequestMapping("/data/position")
    List<PositionData> getPositionData(@RequestBody SearchDataCommon search);


    @RequestMapping("/data/media")
    List<PositionData> getMediaData(@RequestBody SearchDataCommon search);


    /**
     * 代投广告主数据
     * @param proxyAdDataRequest
     * @return
     */
    @RequestMapping("/proxy/advertiser/data/position")
    PageInfo<ProxyDataResponse> getProxyADvertiserData(@RequestBody ProxyAdDataRequest proxyAdDataRequest);
}
