package com.bxm.doris.facade.service;

import com.bxm.doris.facade.constant.DorisFacadeConstants;
import com.bxm.doris.facade.model.RptAdGroupStatHourly;
import com.bxm.doris.facade.model.RtbPositionCvrControlRequest;
import com.bxm.doris.facade.model.RtbPositionGroupHourly;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * @author tangxiao
 * @date 2024/1/25
 * @since 1.0
 */
@FeignClient(name = DorisFacadeConstants.SERVER_NAME)
public interface RtbFacadeService {

    /**
     * rtb cvr相关数据
     * @param search
     * @return
     */
    @RequestMapping("/rtb/getRtbAdGroupCvrData")
    List<RtbPositionGroupHourly> getRtbAdGroupCvrData(@RequestBody RtbPositionCvrControlRequest search);

    /**
     * rtb ad_group小时维度广告数据
     * @param search
     * @return
     */
    @RequestMapping("/rtb/getRtbAdGroupHourData")
    List<RptAdGroupStatHourly> getRtbAdGroupHourData(@RequestBody RtbPositionCvrControlRequest search);
}
