package com.bxm.sync.facade.service;

import com.bxm.sync.facade.dto.InviteFoodsDTO;
import com.bxm.sync.facade.dto.UserTodayContributionDTO;
import com.bxm.sync.facade.param.InviteFoodsParam;

import java.util.List;

/**
 * @author lowi
 * @date 2021/9/30 17:04
 */

public interface SixEnjoyInviteFoodsFacadeService {

    /**
     * 获取总共领取的粮食
     *
     * @param userId 用户id
     * @return 领取的粮食数
     * @deprecated 直接走6享接口，不再使用
     */
    @Deprecated
    Integer getReceiveFoods(Long userId);

    /**
     * 获取当日好友贡献
     *
     * @param inviteFoodsParam 查询信息
     * @return 贡献信息
     * @deprecated 逻辑错误，不再使用
     */
    @Deprecated
    List<InviteFoodsDTO> getTodayContribution(InviteFoodsParam inviteFoodsParam);

    /**
     * 获取用户今日贡献粮食数量
     *
     * @param userIdList 用户ID
     * @return 贡献粮食列表
     * @deprecated 逻辑错误，不再使用
     */
    @Deprecated
    List<UserTodayContributionDTO> getTodayContribution(List<Long> userIdList);


    /**
     * 获取用户今日贡献粮食数量
     *
     * @param userId 用户ID
     * @return 贡献粮食列表
     */
    List<UserTodayContributionDTO> getTodayContribution(Long userId);
}
