package com.bxm.fossicker.activity.domain;

import com.bxm.fossicker.activity.model.vo.ActivityDayGold;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 天天领金币记录表 Mapper 接口
 * </p>
 *
 * @author XinZhao
 * @since 2019-06-25
 */
@Mapper
public interface ActivityDayGoldMapper {

    /**
     * 更新红包状态为已领取
     */
    Boolean obtain(@Param("id") Long id);

    /**
     * 根据用户和今日日期查询红包实体
     */
    ActivityDayGold query(@Param("userId") Long userId, @Param("date") Date date);

    /**
     * 根据用户id获取列表
     */
    List<ActivityDayGold> listByUser(@Param("userId") Long userId);

    /**
     * 根据用户id获取任务个数
     */
    Integer count(@Param("userId") Long userId);

    /**
     * 批量插入
     */
    Boolean batchInsert(@Param("list") List<ActivityDayGold> activityDayGoldList);

    /**
     * 获取所有金币奖励数据
     * @return
     */
    List<ActivityDayGold> allList();

    int updateForGoldNum(@Param("id") Long id, @Param("amount")BigDecimal amount);
}
