package com.bxm.fossicker.activity.domain;

import com.bxm.fossicker.activity.model.vo.ActivitySignLog;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 用户签到日志信息 Mapper 接口
 * </p>
 *
 * @author XinZhao
 * @since 2019-06-25
 */
@Mapper
public interface ActivitySignLogMapper {

    /**
     * 查询用户最后签到的时间
     *
     * @param userId 用户id
     * @return 最后签到时间
     */
    Date querySignLastDate(Long userId);

    /**
     * 添加一条记录
     *
     * @param signLog 签到实体
     * @return 数量
     */
    Integer addOne(ActivitySignLog signLog);


    /**
     * 通过用户id查询签到记录
     *
     * @param userId 用户id
     * @return 签到信息
     */
    List<ActivitySignLog> listByUserId(Long userId);

    /**
     * 根据用户id和签到日期查询签到信息
     * @param userId
     * @param date
     * @return
     */
    ActivitySignLog queryByUserIdAndSignDate(@Param("userId") Long userId, @Param("date") Date date);
}
