package com.bxm.fossicker.activity.domain;

import com.bxm.fossicker.activity.model.entry.ActivityTelephoneCharge;
import com.bxm.fossicker.activity.model.param.telephonecharge.TelephoneChargeListParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface ActivityTelephoneChargeMapper {
    int deleteByPrimaryKey(Long id);

    int insert(ActivityTelephoneCharge record);

    int insertSelective(ActivityTelephoneCharge record);

    ActivityTelephoneCharge selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(ActivityTelephoneCharge record);

    int updateByPrimaryKey(ActivityTelephoneCharge record);

    /**
     * 获取到最后一条信息
     *
     * @param userId 用户id
     * @return 话费信息
     */
    ActivityTelephoneCharge getLastMonthExistData(@Param("userId") Long userId);

    int batchInsertData(@Param("list") List<ActivityTelephoneCharge> activityTelephoneChargeList);

    List<ActivityTelephoneCharge> getActivityTelephoneChargeList(TelephoneChargeListParam telephoneChargeListParam);

    Double getUserNotUseTelephoneChargeNum(Long userId);

    /**
     * 获取当前月份话费信息
     *
     * @param userId   用户id
     * @param currDate 当前时间
     * @return 话费信息
     */
    ActivityTelephoneCharge getCurrMonthTelephoneChargeByUserId(@Param("userId") Long userId, @Param("currDate") Date currDate);

    /**
     * 更新话费的完成天数
     *
     * @param id 话费id
     * @return 成功与否
     */
    int updateFinishDayNum(@Param("id") Long id);

    /**
     * 根据时间和状态更新 每月定期清理话费清单
     *
     * @param currStatus   当前状态
     * @param targetStatus 目标状态
     * @param date         时间
     */
    int updateTelephoneChargeStatus(@Param("currStatus") Byte currStatus,
                                    @Param("targetStatus") Byte targetStatus,
                                    @Param("date") Date date,
                                    @Param("expiredDate") Date expiredDate);

    List<ActivityTelephoneCharge> getExpireCostUserList(@Param("date") Date date);

    /**
     * 统计话费领取记录数量，通过用户id和来源
     *
     * @param userId 用户id
     * @param source 来源
     * @return 记录数量
     */
    int countByUserIdAndSource(@Param("userId") Long userId,
                               @Param("source") Integer source);
}