package com.bxm.fossicker.activity.domain.debris;

import com.bxm.fossicker.activity.model.entity.ActivityAwardEntity;
import com.bxm.fossicker.activity.model.param.debris.ActivityUserPageParam;
import com.bxm.fossicker.activity.model.vo.debris.ActivityListVo;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface ActivityAwardMapper {
    int deleteByPrimaryKey(Long id);

    int insert(ActivityAwardEntity record);

    int insertSelective(ActivityAwardEntity record);

    ActivityAwardEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(ActivityAwardEntity record);

    int updateByPrimaryKey(ActivityAwardEntity record);

    /**
     * 获取活动奖励列表
     *
     * @param userPageParam 分页入参
     * @return 返回数据
     */
    List<ActivityListVo> getActivityAwardList(ActivityUserPageParam userPageParam);

    /**
     * 获取所有的活动奖品
     *
     * @return 活动奖品列表
     */
    List<ActivityAwardEntity> getAllActivityAward();

}