/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.activity.lottery.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.constants.ActivityRedisKeyConstant;
import com.bxm.fossicker.activity.domain.lottery.LotteryParticipantMapper;
import com.bxm.fossicker.activity.domain.lottery.LotteryPhaseMapper;
import com.bxm.fossicker.activity.facade.model.LotteryDTO;
import com.bxm.fossicker.activity.lottery.config.LotteryJoinStatus;
import com.bxm.fossicker.activity.lottery.config.LotteryPhaseStatus;
import com.bxm.fossicker.activity.lottery.service.LotteryDrawService;
import com.bxm.fossicker.activity.lottery.service.LotteryParticipantService;
import com.bxm.fossicker.activity.lottery.service.LotteryPhaseService;
import com.bxm.fossicker.activity.lottery.timer.DrawChanceResetTimer;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryChanceDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryHistoryDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryParticipantDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryPhaseDetailDTO;
import com.bxm.fossicker.activity.model.dto.lottery.LotteryPhaseJoinDTO;
import com.bxm.fossicker.activity.model.param.lottery.LotteryDrawParam;
import com.bxm.fossicker.activity.model.param.lottery.LotteryPhaseQueryParam;
import com.bxm.fossicker.activity.model.param.lottery.LotteryQueryParam;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryParticipantBean;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryPhaseBean;
import com.bxm.fossicker.activity.model.vo.lottery.LotteryVirtaulUserBean;
import com.bxm.fossicker.activity.service.config.ActivityProperties;
import com.bxm.fossicker.base.facade.PointReportFacadeService;
import com.bxm.fossicker.base.facade.param.PointParam;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.VirtualUserFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.fossicker.vo.BasicParam;
import com.bxm.fossicker.vo.PageWarper;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.builder.OnceTaskBuilder;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class LotteryParticipantServiceImpl
extends BaseService
implements LotteryParticipantService,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(LotteryParticipantServiceImpl.class);
    private static final Long HISTORY_EXPIRED_SECONDS = 172800L;
    private static final int MAX_JOIN_TIMES = 3;
    private final ActivityProperties activityProperties;
    private final DistributedLock distributedLock;
    private final LotteryPhaseService lotteryPhaseService;
    private final LotteryParticipantMapper lotteryParticipantMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserInfoFacadeService userInfoFacadeService;
    private final LotteryPhaseMapper lotteryPhaseMapper;
    private final VirtualUserFacadeService virtualUserFacadeService;
    private LotteryDrawService lotteryDrawService;
    @Autowired(required=false)
    private ScheduleService scheduleService;
    private final DrawChanceResetTimer drawChanceResetTimer;
    private ApplicationContext applicationContext;
    private final PointReportFacadeService pointReportFacadeService;

    @Autowired
    public LotteryParticipantServiceImpl(ActivityProperties activityProperties, DistributedLock distributedLock, LotteryPhaseMapper lotteryPhaseMapper, LotteryPhaseService lotteryPhaseService, LotteryParticipantMapper lotteryParticipantMapper, RedisStringAdapter redisStringAdapter, RedisHashMapAdapter redisHashMapAdapter, UserInfoFacadeService userInfoFacadeService, VirtualUserFacadeService virtualUserFacadeService, DrawChanceResetTimer drawChanceResetTimer, PointReportFacadeService pointReportFacadeService) {
        this.activityProperties = activityProperties;
        this.distributedLock = distributedLock;
        this.lotteryPhaseService = lotteryPhaseService;
        this.lotteryParticipantMapper = lotteryParticipantMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userInfoFacadeService = userInfoFacadeService;
        this.lotteryPhaseMapper = lotteryPhaseMapper;
        this.virtualUserFacadeService = virtualUserFacadeService;
        this.drawChanceResetTimer = drawChanceResetTimer;
        this.pointReportFacadeService = pointReportFacadeService;
    }

    private LotteryDrawService getLotteryDrawService() {
        if (this.lotteryDrawService == null) {
            this.lotteryDrawService = (LotteryDrawService)this.applicationContext.getBean(LotteryDrawService.class);
        }
        return this.lotteryDrawService;
    }

    @Override
    public LotteryPhaseJoinDTO addParticipant(LotteryDrawParam param) {
        String requestId;
        LotteryPhaseDetailDTO phase = this.lotteryPhaseService.loadCache(param.getPhaseId());
        LotteryPhaseJoinDTO res = this.validate(param, phase);
        if (null != res) {
            log.debug("\u53c2\u4e0e\u5931\u8d25\uff1a{},\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)res), (Object)param);
            return res;
        }
        String resource = String.valueOf(param.getPhaseId());
        if (this.distributedLock.lock(resource, requestId = this.nextSequence().toString())) {
            String lotteryCode = this.addHistory(param, phase, resource, requestId);
            return LotteryPhaseJoinDTO.builder().status(Integer.valueOf(LotteryJoinStatus.SUCCESS.getCode())).tooltipMsg("\u83b7\u5f97\u4e00\u5f20\u593a\u5b9d\u52b5").lotteryCode(lotteryCode).build();
        }
        log.warn("\u91cd\u590d\u70b9\u51fb\u53c2\u52a0\u6d3b\u52a8\uff1a{}", (Object)param);
        return LotteryPhaseJoinDTO.builder().status(Integer.valueOf(LotteryJoinStatus.SUCCESS.getCode())).lotteryCode("").build();
    }

    @Override
    public void addVirtualUser(Long phaseId) {
        List<LotteryVirtaulUserBean> virtualUsers;
        KeyGenerator key = ActivityRedisKeyConstant.LOTTERY_TEMP_VIRTUAL_KEY.copy().appendKey((Object)phaseId).appendKey((Object)this.getHalfHourKey());
        if (this.redisStringAdapter.hasKey(key).booleanValue()) {
            TypeReference<List<LotteryVirtaulUserBean>> typeReference = new TypeReference<List<LotteryVirtaulUserBean>>(){};
            virtualUsers = (List<LotteryVirtaulUserBean>)this.redisStringAdapter.get(key, (TypeReference)typeReference);
        } else {
            int currentMin = 30 - DateUtils.getField((Date)new Date(), (int)12) % 30;
            int randomNum = RandomUtils.nextInt((int)(this.activityProperties.getVirtualMinNum() * currentMin / 30), (int)(this.activityProperties.getVirtualMaxNum() * currentMin / 30));
            if (randomNum < 1) {
                randomNum = 1;
            }
            List sourceVirtualUsers = this.virtualUserFacadeService.listVirtualUser(Integer.valueOf(randomNum));
            virtualUsers = sourceVirtualUsers.stream().map(user -> LotteryVirtaulUserBean.builder().addTime(this.getRandomDate()).headImg(user.getHeadImg()).sex(user.getSex()).nickname(user.getNickname()).id(user.getId()).build()).collect(Collectors.toList());
            this.redisStringAdapter.set(key, virtualUsers, 1800L);
        }
        virtualUsers.sort((u1, u2) -> (int)(u1.getAddTime().getTime() - u2.getAddTime().getTime()));
        ArrayList afterJoin = Lists.newArrayList();
        afterJoin.addAll(virtualUsers);
        virtualUsers.forEach(user -> {
            if (DateUtils.before((Date)user.getAddTime())) {
                this.addParticipant(LotteryDrawParam.builder().virtaulUser(user).virtual(Boolean.valueOf(true)).phaseId(phaseId).userId(user.getId()).lastVirtual(Boolean.valueOf(false)).build());
                afterJoin.remove(user);
            }
        });
        this.redisStringAdapter.set(key, (Object)afterJoin, 1800L);
    }

    private Date getRandomDate() {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        Calendar afterHalfHour = Calendar.getInstance();
        afterHalfHour.setTime(now);
        afterHalfHour.set(13, 0);
        afterHalfHour.set(14, 0);
        int minute = afterHalfHour.get(12);
        if (minute >= 30) {
            afterHalfHour.set(12, 0);
            afterHalfHour.add(10, 1);
        } else {
            afterHalfHour.set(12, 30);
        }
        int diffMillSeconds = (int)(afterHalfHour.getTimeInMillis() - calendar.getTimeInMillis());
        calendar.add(14, RandomUtils.nextInt((int)0, (int)diffMillSeconds));
        return calendar.getTime();
    }

    private String getHalfHourKey() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int minute = calendar.get(12);
        String key = calendar.get(5) + "" + calendar.get(11);
        key = minute >= 30 ? key + "30" : key + "00";
        return key;
    }

    private LotteryPhaseJoinDTO validate(LotteryDrawParam param, LotteryPhaseDetailDTO phase) {
        boolean joinCondition;
        if (!param.getVirtual().booleanValue()) {
            int joinTimes = this.getTodayJoinTimes(param.getUserId(), param.getPhaseId());
            if (joinTimes >= 3) {
                return LotteryPhaseJoinDTO.builder().status(Integer.valueOf(LotteryJoinStatus.MAX_TIMES.getCode())).tooltipMsg("\u6bcf\u671f\u6d3b\u52a8\u6bcf\u5929\u53ea\u80fd\u53c2\u52a0\u4e09\u6b21").build();
            }
            long chances = this.getChances(param.getUserId());
            if (chances <= 0L) {
                return LotteryPhaseJoinDTO.builder().tooltipMsg("\u672c\u9636\u6bb5\u7684\u62bd\u5956\u6b21\u6570\u5df2\u7528\u5b8c").status(Integer.valueOf(LotteryJoinStatus.LACK.getCode())).nextChanceSeconds(Long.valueOf(this.getNextChanesSeconds(param.getUserId()))).build();
            }
        }
        long joinNum = this.getJoinNum(phase.getPhaseId());
        boolean bl = joinCondition = param.getLastVirtual() == false && (phase.getStatus().intValue() != LotteryPhaseStatus.GOING.getCode() || (long)phase.getConditionNum().intValue() - joinNum <= 1L);
        if (joinCondition) {
            LotteryPhaseJoinDTO res = LotteryPhaseJoinDTO.builder().status(Integer.valueOf(LotteryJoinStatus.FINISH.getCode())).build();
            if (phase.getLastPhaseId() != null) {
                res.setTooltipMsg("\u6765\u665a\u54af\uff0c\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u53c2\u52a0\u4e0b\u4e00\u671f\u5427");
                res.setLastPhaseId(phase.getLastPhaseId());
            } else {
                res.setTooltipMsg("\u6765\u665a\u54af\uff0c\u6d3b\u52a8\u5df2\u7ed3\u675f\uff0c\u53c2\u52a0\u5176\u4ed6\u62bd\u5956\u5427");
            }
            return res;
        }
        return null;
    }

    private String addHistory(LotteryDrawParam param, LotteryPhaseDetailDTO phase, String resource, String requestId) {
        LotteryParticipantBean entity;
        if (!param.getVirtual().booleanValue()) {
            this.decrementChances(param.getUserId());
        }
        long joinNum = this.execJoinCache(param);
        String joinCode = this.createLotteryCode(joinNum);
        log.debug("\u53c2\u4e0e\u53c2\u6570\uff1a{},\u5956\u5238\u53f7\u7801:{}\uff0c\u53c2\u4e0e\u4eba\u6570\uff1a{}", new Object[]{param, joinCode, joinNum});
        LotteryPhaseBean modifyPhase = LotteryPhaseBean.builder().id(param.getPhaseId()).participantNum(Integer.valueOf((int)joinNum)).build();
        this.lotteryPhaseMapper.updateByPrimaryKeySelective(modifyPhase);
        if (param.getVirtual().booleanValue()) {
            entity = LotteryParticipantBean.builder().id(Long.valueOf(this.nextId())).code(joinCode).createTime(param.getVirtaulUser().getAddTime()).phaseId(param.getPhaseId()).userId(param.getUserId()).userName(param.getVirtaulUser().getNickname()).userHead(param.getVirtaulUser().getHeadImg()).userType(param.getVirtual()).build();
        } else {
            UserInfoDto userInfo = this.userInfoFacadeService.getUserById(param.getUserId());
            entity = LotteryParticipantBean.builder().id(Long.valueOf(this.nextId())).code(joinCode).createTime(new Date()).phaseId(param.getPhaseId()).userId(param.getUserId()).userName(userInfo.getNickName()).userHead(userInfo.getHeadImg()).userType(param.getVirtual()).build();
        }
        this.lotteryParticipantMapper.insert(entity);
        this.lotteryPhaseService.cleanCache(phase.getPhaseId());
        this.distributedLock.unlock(resource, requestId);
        log.debug("\u6d3b\u52a8\u53c2\u4e0e\u60c5\u51b5\uff0c\u53c2\u4e0e\u4eba\u6570\uff1a{}\uff0c\u9884\u8ba1\u5f00\u5956\u4eba\u6570\uff1a{},\u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{joinNum, phase.getConditionNum(), param});
        if (!param.getLastVirtual().booleanValue() && joinNum == (long)(phase.getConditionNum() - 1)) {
            this.getLotteryDrawService().doDraw(param.getPhaseId(), phase.getTitle());
        }
        this.report(param);
        return joinCode;
    }

    private void report(LotteryDrawParam param) {
        if (param.getVirtual().booleanValue()) {
            return;
        }
        this.pointReportFacadeService.add(PointParam.build((BasicParam)param).e("3034").ev("102." + param.getPhaseId()).put("uid", String.valueOf(param.getUserId())));
    }

    private long getJoinNum(Long phaseId) {
        KeyGenerator key = ActivityRedisKeyConstant.LOTTERY_PHASE_NUM_KEY.copy().appendKey((Object)phaseId);
        return this.redisStringAdapter.getLong(key);
    }

    private long execJoinCache(LotteryDrawParam param) {
        String phaseIdStr = String.valueOf(param.getPhaseId());
        KeyGenerator key = ActivityRedisKeyConstant.LOTTERY_PHASE_NUM_KEY.copy().appendKey((Object)param.getPhaseId());
        long joinNum = this.redisStringAdapter.increment(key);
        if (!param.getVirtual().booleanValue()) {
            KeyGenerator userJoinKey = ActivityRedisKeyConstant.LOTTERY_JOIN_HISTORY_KEY.copy().appendKey((Object)param.getUserId());
            Integer times = (Integer)this.redisHashMapAdapter.get(userJoinKey, phaseIdStr, Integer.class);
            if (times == null) {
                times = 0;
            }
            times = times + 1;
            this.redisHashMapAdapter.put(userJoinKey, phaseIdStr, (Object)times);
            KeyGenerator todayJoinKey = this.buildTodayJoinKey(param.getUserId());
            times = (Integer)this.redisHashMapAdapter.get(todayJoinKey, phaseIdStr, Integer.class);
            if (times == null) {
                times = 0;
            }
            times = times + 1;
            this.redisHashMapAdapter.put(todayJoinKey, phaseIdStr, (Object)times);
            this.redisHashMapAdapter.expire(todayJoinKey, (long)DateUtils.getCurSeconds());
        }
        return joinNum;
    }

    private String createLotteryCode(Long participantNum) {
        long codeValue = (long)this.activityProperties.getCodePrefix() + participantNum;
        return String.valueOf(codeValue);
    }

    private void decrementChances(Long userId) {
        KeyGenerator key = ActivityRedisKeyConstant.LOTTERY_DRAW_CHANCE_KEY.copy().appendKey((Object)userId);
        if (this.redisStringAdapter.hasKey(key).booleanValue()) {
            KeyGenerator nextChanceSeconds = ActivityRedisKeyConstant.LOTTERY_NEXT_CHANCE_KEY.copy().appendKey((Object)userId);
            long afterDecrement = this.redisStringAdapter.decrement(key);
            if (afterDecrement == 0L) {
                long resetSeconds = this.getChangeExpiredSeconds();
                long expiredSeconds = resetSeconds - System.currentTimeMillis() / 1000L;
                this.redisStringAdapter.set(nextChanceSeconds, (Object)resetSeconds, expiredSeconds);
                this.pushNotify(userId, resetSeconds);
                return;
            }
            if (afterDecrement < 0L && this.redisStringAdapter.hasKey(nextChanceSeconds).booleanValue()) {
                log.error("\u8c03\u7528\u4e86\u6263\u9664\u62bd\u5956\u6b21\u6570\u65b9\u6cd5\uff0c\u4f46\u662f\u6b21\u6570\u5df2\u4e3a\u8d1f\u6570\uff0c\u903b\u8f91\u9519\u8bef\uff0c\u7528\u6237ID\uff1a{}", (Object)userId);
                return;
            }
            return;
        }
        long chances = this.activityProperties.getMaxChances() - 1L;
        this.redisStringAdapter.set(key, chances);
        this.redisStringAdapter.expire(key, (long)DateUtils.getCurSeconds());
    }

    private void pushNotify(Long userId, long nextChanceSeconds) {
        log.debug("\u7528\u6237[{}]\u62bd\u5956\u6b21\u6570\u5df2\u7528\u5b8c\uff0c\u8ddd\u79bb\u4e0b\u6b21\u62bd\u5956\uff1a{}", (Object)userId, (Object)nextChanceSeconds);
        if (nextChanceSeconds < this.activityProperties.getLoopSeconds()) {
            log.info("\u96f6\u70b9\u7684\u62bd\u5956\u673a\u4f1a\u91cd\u7f6e\u4e0d\u4ea7\u751f\u63a8\u9001,userId:{},nextChanceSeconds:{}", (Object)userId, (Object)nextChanceSeconds);
            return;
        }
        if (null != this.scheduleService) {
            Date fireDate = new Date(nextChanceSeconds * 1000L);
            this.scheduleService.push((ScheduleTask)OnceTaskBuilder.builder((Date)fireDate, (TaskCallback)this.drawChanceResetTimer).callbackParam((Object)userId).taskName("resetChances_" + userId).author("liujia").description("\u901a\u77e5\u7528\u6237\u62bd\u5956\u6b21\u6570\u5df2\u91cd\u7f6e").build());
        }
    }

    private long getChances(Long userId) {
        KeyGenerator key = ActivityRedisKeyConstant.LOTTERY_DRAW_CHANCE_KEY.copy().appendKey((Object)userId);
        KeyGenerator nextChanceSeconds = ActivityRedisKeyConstant.LOTTERY_NEXT_CHANCE_KEY.copy().appendKey((Object)userId);
        if (this.redisStringAdapter.hasKey(key).booleanValue()) {
            if (this.redisStringAdapter.hasKey(nextChanceSeconds).booleanValue()) {
                return 0L;
            }
            long chances = this.redisStringAdapter.getLong(key);
            if (chances > 0L) {
                return chances;
            }
        }
        this.redisStringAdapter.set(key, this.activityProperties.getMaxChances());
        this.redisStringAdapter.expire(key, (long)DateUtils.getCurSeconds());
        return this.activityProperties.getMaxChances();
    }

    private long getNextChanesSeconds(Long userId) {
        KeyGenerator key = ActivityRedisKeyConstant.LOTTERY_NEXT_CHANCE_KEY.copy().appendKey((Object)userId);
        long expiredTime = this.redisStringAdapter.getLong(key);
        if (expiredTime == 0L) {
            return expiredTime;
        }
        return expiredTime - System.currentTimeMillis() / 1000L;
    }

    private long getChangeExpiredSeconds() {
        long maxLoopSeconds = this.activityProperties.getLoopSeconds();
        long lastSeconds = DateUtils.getCurSeconds();
        return Math.min(maxLoopSeconds, lastSeconds) + System.currentTimeMillis() / 1000L;
    }

    private Integer getTodayJoinTimes(Long userId, Long phaseId) {
        KeyGenerator key = this.buildTodayJoinKey(userId);
        Integer times = (Integer)this.redisHashMapAdapter.get(key, phaseId.toString(), Integer.class);
        if (times == null) {
            return 0;
        }
        return times;
    }

    private KeyGenerator buildTodayJoinKey(Long userId) {
        return ActivityRedisKeyConstant.LOTTERY_JOIN_TODAY_KEY.copy().appendKey((Object)DateUtils.formatDate((Date)new Date())).appendKey((Object)userId);
    }

    @Override
    public Map<String, Integer> loadJoinHistoryMap(Long userId, Long phaseId) {
        String phaseIdStr;
        KeyGenerator key = ActivityRedisKeyConstant.LOTTERY_JOIN_HISTORY_KEY.copy().appendKey((Object)userId);
        Map<String, Integer> res = Maps.newHashMap();
        String string = phaseIdStr = null == phaseId ? null : String.valueOf(phaseId);
        if (this.redisHashMapAdapter.hasKey(key).booleanValue()) {
            HashMap tempMap = Maps.newHashMap();
            List histories = this.lotteryParticipantMapper.getUserJoinHistory(userId);
            histories.forEach(item -> tempMap.put(String.valueOf(item.getPhaseId()), item.getCount()));
            if (tempMap.size() == 0) {
                tempMap.put("-1", -1);
            }
            this.redisHashMapAdapter.putAll(key, (Map)tempMap);
            this.redisHashMapAdapter.expire(key, HISTORY_EXPIRED_SECONDS.longValue());
            if (null != phaseId) {
                res.put(phaseIdStr, (Integer)tempMap.get(phaseIdStr));
            } else {
                res.putAll(tempMap);
            }
        } else if (null != phaseId) {
            int count = (Integer)this.redisHashMapAdapter.get(key, phaseIdStr, Integer.class);
            res.put(phaseIdStr, count);
        } else {
            res = this.redisHashMapAdapter.entries(key, Integer.class);
        }
        return res;
    }

    @Override
    public PageWarper<LotteryParticipantDTO> getParticipantList(LotteryPhaseQueryParam param) {
        if (null == param) {
            param = new LotteryPhaseQueryParam();
        }
        List result = this.lotteryParticipantMapper.getParticipantByPage(param);
        return new PageWarper(result);
    }

    @Override
    public LotteryChanceDTO getUserChance(Long userId) {
        return LotteryChanceDTO.builder().maxChances(Integer.valueOf((int)this.activityProperties.getMaxChances())).nextChanceSeconds(Long.valueOf(this.getNextChanesSeconds(userId))).residueChances(Integer.valueOf((int)this.getChances(userId))).build();
    }

    @Override
    public PageWarper<LotteryHistoryDTO> getHistoryPhaseList(LotteryQueryParam param) {
        List result = this.lotteryParticipantMapper.getUserHistoryByPage(param);
        Map<String, Integer> userJoinHistories = this.loadJoinHistoryMap(param.getUserId(), null);
        for (LotteryDTO item : result) {
            Integer joinTimes = userJoinHistories.get(String.valueOf(item.getPhaseId()));
            if (null == joinTimes || joinTimes <= 0) continue;
            item.setTimes(joinTimes);
        }
        return new PageWarper(result);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

